/* point.c */

#include "point.h"
#include "Memory.h"
#include "debug.h"

static int TotalPoints = 0;

#ifdef BETTER_MEMMAN
static STORAGE *pointStor = (STORAGE *)NULL;
#define NEWPOINT()  	(POINT *)New(sizeof(POINT), &pointStor)
#define DISPOSEPOINT(ptr) Dispose((unsigned char *)(ptr), &pointStor)
#else /*BETTER_MEMMAN*/
#define NEWPOINT()	(POINT *)Alloc(sizeof(POINT))
#define DISPOSEPOINT(ptr) Free((char *)ptr, sizeof(POINT))
#endif /*BETTER_MEMMAN*/


POINT *PointCreate(float x, float y, float z)
{
	POINT *p;

	p = NEWPOINT();
	p->x = x;
	p->y = y;
	p->z = z;

	TotalPoints++;

	return p;
}

void PointDestroy(POINT *point)
{
	DISPOSEPOINT(point);

	TotalPoints--;
}

POINT *PointCopy(POINT *point)
{
	POINT *newpoint;

	newpoint = NEWPOINT();
	*newpoint = *point;
	return newpoint;
}

