/* patchlist.h: lineaire lijsten van PATCHs */

#ifndef _PATCHLIST_H_
#define _PATCHLIST_H_

#include "patch.h"
#include "List.h"

typedef struct PATCHLIST {
	struct PATCH *patch;
	struct PATCHLIST *next;
} PATCHLIST;

#define PatchListCreate	(PATCHLIST *)ListCreate

#define PatchListAdd(patchlist, patch)	\
        (PATCHLIST *)ListAdd((LIST *)patchlist, (void *)patch)

#define PatchListCount(patchlist) \
        ListCount((LIST *)patchlist)

#define PatchListGet(patchlist, index) \
        (PATCH *)ListGet((LIST *)patchlist, index)

#define PatchListDuplicate(patchlist) \
        (PATCHLIST *)ListDuplicate((LIST *)patchlist)

#define PatchListNext(ppatchlist) \
        (PATCH *)ListNext((LIST **)ppatchlist)

#define PatchListMerge(patchlist1, patchlist2) \
        (PATCHLIST *)ListMerge((LIST *)patchlist1, (LIST *)patchlist2);

#define PatchListRemove(patchlist, patch) \
        (PATCHLIST *)ListRemove((LIST *)patchlist, (void *)patch)

#define PatchListIterate(patchlist, proc) \
        ListIterate((LIST *)patchlist, (void (*)(void *))proc)

#define PatchListIterate1A(patchlist, proc, data) \
        ListIterate1A((LIST *)patchlist, (void (*)(void *, void *))proc, (void *)data)

#define PatchListIterate1B(patchlist, proc, data) \
        ListIterate1B((LIST *)patchlist, (void (*)(void *, void *))proc, (void *)data)

#define PatchListDestroy(patchlist) \
        ListDestroy((LIST *)patchlist)

#define PatchListPrint(fp, patchlist) \
        PatchListIterate1B(patchlist, PatchPrint, fp);

#include "ray.h"

extern struct PATCH *PatchListIntersect(PATCHLIST *pl, RAY *ray, float mindist, float *maxdist, int ShadowTesting);

extern float *PatchListBounds(PATCHLIST *pl, float *boundingbox);

extern struct GEOM_METHODS patchlistMethods;
extern struct GEOM_METHODS *PatchListMethods(void);

#endif /* _PATCHLIST_H_ */
