/* methods.h */

#ifndef _METHODS_H_
#define _METHODS_H_

#include <stdio.h>

#include "boolean.h"
#include "ray.h"
#include "bounds.h"
#include "patch.h"
#include "patchlist.h"
#include "geomlist.h"

typedef struct GEOM_METHODS {
	float *(*bounds)(void *obj, float *boundingbox);
	void   	(*destroy)(void *obj);
	void   	(*print)(FILE *out, void *obj);
/* intersect should return the closest intersecting patch if ShadowTesting is FALSE */
	struct PATCH	*(*intersect)(void *obj, RAY *ray, float mindist, float *maxdist, int ShadowTesting);
	struct GEOMLIST *(*primlist)(void *obj);
	struct PATCHLIST *(*patchlist)(void *obj);
	void	*(*duplicate)(void *obj);
} GEOM_METHODS;

#endif /*_METHODS_H_*/
