/* compound.h */
#ifndef _COMPOUND_H_
#define _COMPOUND_H_

#include <stdio.h>
#include "geomlist.h"

typedef struct COMPOUND {
	GEOMLIST *geomlist;
	char *dummy;	/* om aan 8 bytes te komen */
} COMPOUND;

extern COMPOUND *CompoundCreate(GEOMLIST *geomlist);
extern GEOM_METHODS *CompoundMethods(void);
extern float *CompoundBounds(COMPOUND *obj, float *boundingbox);
extern void   CompoundDestroy(COMPOUND *obj);
extern void   CompoundPrint(FILE *out, COMPOUND *obj);
extern struct PATCH *CompoundIntersect(COMPOUND *obj, RAY *ray, float mindist, float *maxdist, int ShadowTesting);
extern struct GEOMLIST *CompoundPrimitives(COMPOUND *obj);

extern GEOM_METHODS compoundMethods;

#endif /*_COMPOUND_H_*/
