/* compound.c */
#include <stdio.h>
#include <stdlib.h>
#include "compound.h"
#include "error.h"
#include "Memory.h"
#include "geom.h"

#ifdef BETTER_MEMMAN
static STORAGE *compoundStor = (STORAGE *)NULL;
#define NEWCOMPOUND()  	(COMPOUND *)New(sizeof(COMPOUND), &compoundStor)
#define DISPOSECOMPOUND(ptr) Dispose((unsigned char *)(ptr), &compoundStor)
#else /*BETTER_MEMMAN*/
#define NEWCOMPOUND()	(COMPOUND *)Alloc(sizeof(COMPOUND))
#define DISPOSECOMPOUND(ptr) Free((char *)ptr, sizeof(COMPOUND))
#endif /*BETTER_MEMMAN*/


COMPOUND *CompoundCreate(GEOMLIST *geomlist)
{
	COMPOUND *com;

	if (GeomListCount(geomlist) < 1) {
		Warning("CompoundCreate", "list without surfaces");
		return (COMPOUND *)NULL;
	}

	com = NEWCOMPOUND();
	com->geomlist = geomlist;
	return com;
}

float *CompoundBounds(COMPOUND *obj, float *boundingbox)
{
	return GeomListBounds(obj->geomlist, boundingbox);
}

void   CompoundDestroy(COMPOUND *obj)
{
	GeomListIterate(obj->geomlist, GeomDestroy);
	GeomListDestroy(obj->geomlist);
	DISPOSECOMPOUND(obj);
}

void   CompoundPrint(FILE *out, COMPOUND *obj)
{
	fprintf(out, "list\n");
	GeomListPrint(out, obj->geomlist);
	fprintf(out, "end\n");
}

struct PATCH *CompoundIntersect(COMPOUND *obj, RAY *ray, float mindist, float *maxdist, int ShadowTesting)
{
	return GeomListIntersect(obj->geomlist, ray, mindist, maxdist, ShadowTesting);
}

GEOMLIST *CompoundPrimitives(COMPOUND *obj)
{
	return obj->geomlist;
}


GEOM_METHODS compoundMethods = {
	(float *(*)(void *, float *))CompoundBounds,
	(void (*)(void *))CompoundDestroy,
	(void (*)(FILE *, void *))CompoundPrint,
	(PATCH *(*)(void *, RAY *, float, float *, int))CompoundIntersect,
	(GEOMLIST *(*)(void *))CompoundPrimitives,
	(PATCHLIST *(*)(void *))NULL,
	(void *(*)(void *))NULL
};

GEOM_METHODS *CompoundMethods(void)
{
	return &compoundMethods;
}

