/* basis.c: bases for radiosity approximation */

#include "bases.h"
#include "debug.h"
#include "sole.h"

BASIS *quadBasis, *triBasis;

void SetBasis(BASIS *quadbasis, BASIS *tribasis)
{
	if (quadbasis) quadBasis = quadbasis;
	if (tribasis)  triBasis = tribasis;
}

#ifdef NEVER
/* there are more efficient versions of this routine for each basis function
 * set separately ... */
void Renormalize(PATCH *P, COLOR *in, COLOR *out)
{
	Float f, *fp;
	int alpha, beta;
	COLOR new[BASISMAXSIZE];

	if (P->basis->orthogonal && !P->jacobian) {
		for (alpha=0; alpha<P->basis->size; alpha++) {
			f = 1./P->basis->norm[alpha](P); 
			COLORSCALE(f, in[alpha], out[alpha]);
		}
	} else {
		fp = (P->inverse_overlap ? P->inverse_overlap : P->basis->standard_inverse_overlap);
		for (alpha=0; alpha<P->basis->size; alpha++) {
			COLORCLEAR(new[alpha]);
			for (beta=0; beta<P->basis->size; beta++, fp++)
				COLORADDSCALED(new[alpha], *fp, in[beta], new[alpha]);
		}	

		if (!P->inverse_overlap) {	/* standard inverse overlap matrix was used, so divide by P->area */
			for (alpha=0; alpha<P->basis->size; alpha++)
				COLORSCALEINVERSE(P->area, new[alpha], out[alpha]);
		} else {
			for (alpha=0; alpha<P->basis->size; alpha++)
				out[alpha] = new[alpha];
		}
	}
}
#endif /*NEVER*/
