/* Octree.h: routines for dealing with octrees. */

#ifndef _OCTREE_H_
#define _OCTREE_H_

typedef struct OCTREE {
	void *pelement;
	struct OCTREE *child[8];
} OCTREE;

#define OctreeCreate()	(OCTREE *)NULL

extern OCTREE *OctreeAdd(OCTREE *octree, void *element, int (*nodecmp)(void *pelem1, void *pelem2));

extern void *OctreeFind(OCTREE *octree, void *element, int (*nodecmp)(void *pelem1, void *pelem2));

extern void OctreeDestroy(OCTREE *octree);

extern void OctreeIterate(OCTREE *octree, void (*func)(void *pelem));

#endif _OCTREE_H_
