/**********************************************************************/
/* scull.h                                                            */
/*                                                                    */
/* Constants and definitions for shaft culling                        */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/
#define MINX 0             /* Flags for reference list creation */
#define MINY 1
#define MINZ 2
#define MAXX 3
#define MAXY 4
#define MAXZ 5

#define OUTSIDE 0          /* Flags for candidate list creation */
#define OVERLAP 1
#define INSIDE 2
#define CONTAINS 3

#define HBOX -1
#define Candidate_type(cand) ((cand)->object == NULL ? HBOX \
			      : (cand)->object->primid)

typedef struct {           /* Reference list */
  int dir[6];              /* X,Y or Z  0,1,2 = min(X,Y,Z), 
			      3,4,5 = max(X,Y,Z) dir[i] = FALSE means 
			      not represented */
  double pt[6];            
} RefListtype;

typedef struct {           /* Plane set = shaft */
  Plane planes[8];         /* Up to 8 possible planes for culling shaft */
  int num_planes;          /* Number of planes in plane set */  
} PlaneSettype;

#define KEEP_CLOSED  0     /* Shaft strategies */
#define ALWAYS_OPEN  1
#define OVERLAP_OPEN 2
#define RATIO_OPEN   3

typedef struct {           /* Shaft statisitics */
  int strategy;            /* shaft-box strategy */
  double ratio_open;       /* Ratio to open, if use this strategy */
  int BoxIn, BoxOut,       /* Boxes in, out, overlapping, and boxes tested */
  BoxOverlap, BoxContains,
  BoxTests;          
  int candCube, candSphere, candCone,
  candMesh, candCyl, candHbox;
  int candidates;          /* Size of Candidate list */
  int total_shafts;        /* Total shafts formed */
  int total_candidates;    /* Total candidates for shafts */
  int total_BoxIn,         /* Total boxes in, out, overlap, containing, and */
  total_BoxOut,            /* tests */
  total_BoxOverlap, 
  total_BoxContains,
  total_BoxTests;
  
} ShaftStatstype;

/**********************************************************************/
/* Prototypes */
/**********************************************************************/
void Form_Extent_Culledges();
void Form_Plane_Set();
void Form_Culling_Shaft();
int isCandidate();
int Form_Candidate_List();

extern void StartShaft();
extern void ShaftCull();
extern void EndShaft();
