/**********************************************************************/
/* adj.h:                                                             */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/
/* requires geo.h, struct.h */

#ifndef ADJ_H
#define ADJ_H

#define VTX_TOLERANCE 0.0001     /* If within this distance, same vtx */

/**********************************************************************/
/* Vertex octree structures                                           */
/**********************************************************************/
#define num_octants 8                         /* number of sons */

/* Note from front of volume: 
 * right = east (E), left = west (W), top = nort(N) and 
 * bottom = south (S), F is front and B is back
 *
 * Also positive X is east, positive Y is front, and
 * positive Z is north
 */
#define NWF 0                             /* Octant labels */
#define NEF 1                             
#define SWF 2
#define SEF 3
#define NWB 4
#define NEB 5
#define SWB 6
#define SEB 7

typedef struct Vertex_tree {              /* Vertex octree node */
  Vertex *vtx;                            /* Vertex = cutting point 
					     in octant */
  struct Vertex_tree                      /* Children */
    *child[num_octants];
  struct Vertex_tree *father;             /* Father node */
} Vertex_tree;

/**********************************************************************/
extern int vsame();

extern Vertex_tree *VTree_Create();
extern Vertex_tree *VTree_NodeCreate();
extern void VTree_NodeAddChild();
extern int Vtree_VectorOctant();
extern int VTree_NodeFind();

extern Vertex *Vertex_Create();
extern void LinkPoly_ToVertex();
extern void LinkVertex_ToPoly();

extern void Create_Subdivision_Points();
extern void Subdivide_Polygon();

#endif /* ADJ_H */
