/* FILE: block.h

   Prototypes for routines creating, deleting, extracting and copying blocks
   (=pictures). Prototypes for routines to resize, flip and rotate blocks.

   Written by Petri Kuittinen, last modifications 2nd August 1993.
*/ 

struct picture *create_block (char *name, int width, int height);
struct picture *duplicate_block (struct picture *pic_p);
struct picture *copy_block (struct picture *pic_p, int x1, int y1, int x2,
			    int y2);
void swap_blocks (struct picture *pic_p1, struct picture *pic_p2, int x,
		  int y);
void delete_block (struct picture *pic_p);
void vflip_block (struct picture *pic_p);
void hflip_block (struct picture *pic_p);
struct picture *resize_block (struct picture *pic_p, int new_w, int new_h);
struct picture *rotate_block (struct picture *pic_p, double angle);
struct picture *extract_block1 (struct picture *pic_p, int x1, int y1, int x2,
				int y2, pixel bits);
struct picture *extract_block2 (struct picture *pic_p, int x1, int y1, int x2,
				int y2, pixel bits);
struct picture *extract_block3 (struct picture *pic_p, int x1, int y1, int x2,
				int y2, pixel bits);
