/*
 bitmaps.c: Create bitmaps for tool buttons and cursors.
  
 $Header: bitmaps.c,v 2.5 93/09/03 14:46:21 wet Exp $
 */
#include <X11/Intrinsic.h>
#include "bitmaps.h"
#include "bitmaps/point"
#include "bitmaps/line"
#include "bitmaps/brushopt"
#include "bitmaps/circle"
#include "bitmaps/perim"
#include "bitmaps/boxselect"
#include "bitmaps/lassoselect"
#include "bitmaps/selectall"
#include "bitmaps/replace"
#include "bitmaps/everywhere"
#include "bitmaps/draw"
#include "bitmaps/polyline"
#include "bitmaps/fillopt"
#include "bitmaps/ellipse"
#include "bitmaps/filled"
#include "bitmaps/ellipseselect"
#include "bitmaps/colorselect"
#include "bitmaps/deselectall"
#include "bitmaps/add"
#include "bitmaps/inside"
#include "bitmaps/airbrush"
#include "bitmaps/fill"
#include "bitmaps/colorext"
#include "bitmaps/box"
#include "bitmaps/filledperim"
#include "bitmaps/polygonselect"
#include "bitmaps/showmask"
#include "bitmaps/clone"
#include "bitmaps/substract"
#include "bitmaps/outside"

#include "bitmaps/hour_c"
#include "bitmaps/hour_c_m"
#include "bitmaps/draw_c"
#include "bitmaps/draw_c_m"
#include "bitmaps/airbrush_c"
#include "bitmaps/airbrush_c_m"
#include "bitmaps/select_c"
#include "bitmaps/select_c_m"
#include "bitmaps/fill_c"
#include "bitmaps/fill_c_m"
#include "bitmaps/colorext_c"
#include "bitmaps/colorext_c_m"

/* FUNCTION:       create_cursors(Widget toplevel)
   DESCRIPTION:    Creates the different pointers used by phoenix.
   PARAMETERS:
   void            None.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications th July 1993.
*/
void create_cursors(Widget toplevel)
{
  Display *disp = XtDisplay(toplevel);
  Window root = DefaultRootWindow(disp);
  Pixmap h_g, h_g_m, a_b, a_b_m, d, d_m, f, f_m, s, s_m, c, c_m;
  XColor white, black;
  white.red = white.green = white.blue = 65535;
  white.flags = DoRed|DoGreen|DoBlue;
  black.red = black.green = black.blue = 0;
  black.flags = DoRed|DoGreen|DoBlue;
  
  /* hourglass cursor and it's mask */
  h_g = XCreateBitmapFromData(disp, root, hour_c_bits, hour_c_width,
			      hour_c_height);
  h_g_m =  XCreateBitmapFromData(disp, root, hour_c_m_bits,
				 hour_c_m_width, hour_c_m_height);
  hourglass_c = XCreatePixmapCursor(disp, h_g, h_g_m, &black, &white,
				  hour_c_x_hot, hour_c_y_hot);

  /* airbrush cursor */
  a_b = XCreateBitmapFromData(disp, root, airbrush_c_bits, airbrush_c_width,
			      airbrush_c_height);
  a_b_m =  XCreateBitmapFromData(disp, root, airbrush_c_m_bits,
				 airbrush_c_m_width, airbrush_c_m_height);
  airbrush_c = XCreatePixmapCursor(disp, a_b, a_b_m, &black, &white,
				 airbrush_c_x_hot, airbrush_c_y_hot);

  /* pencil cursor */
  d = XCreateBitmapFromData(disp, root, draw_c_bits, draw_c_width,
			      draw_c_height);
  d_m =  XCreateBitmapFromData(disp, root, draw_c_m_bits,
				 draw_c_m_width, draw_c_m_height);
  draw_c = XCreatePixmapCursor(disp, d, d_m, &black, &white,
				  draw_c_x_hot, draw_c_y_hot);

  /* flood fill cursor */
  f = XCreateBitmapFromData(disp, root, fill_c_bits, fill_c_width,
			      fill_c_height);
  f_m =  XCreateBitmapFromData(disp, root, fill_c_m_bits,
				 fill_c_m_width, fill_c_m_height);
  fill_c = XCreatePixmapCursor(disp, f, f_m, &black, &white,
				  fill_c_x_hot, fill_c_y_hot);

  /* hand cursor (selection) */
  s = XCreateBitmapFromData(disp, root, select_c_bits, select_c_width,
			      select_c_height);
  s_m =  XCreateBitmapFromData(disp, root, select_c_m_bits,
				 select_c_m_width, select_c_m_height);
  select_c = XCreatePixmapCursor(disp, s, s_m, &black, &white,
				  select_c_x_hot, select_c_y_hot);

  /* color extract tool cursor (crosshair) */
  c = XCreateBitmapFromData(disp, root, colorext_c_bits, colorext_c_width,
			    colorext_c_height);
  c_m =  XCreateBitmapFromData(disp, root, colorext_c_m_bits,
			       colorext_c_m_width, colorext_c_m_height);
  colorext_c = XCreatePixmapCursor(disp, c, c_m, &black, &white,
				colorext_c_x_hot, colorext_c_y_hot);
}



/* FUNCTION:       init_pixmaps(Widget widget_id, Pixel fg, Pixel bg, Pixel ac)
   DESCRIPTION:    Creates an array of pixmaps for the tool buttons.
   PARAMETERS:
   Widget widget_id Widget on the screen the pixmaps are to be used.
   Pixel fg         Foreground color.
   Pixel bg         Background color.
   Pixel ac         Arm color.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 10th August 1993.
*/   
void init_pixmaps(Widget widget_id, Pixel fg, Pixel bg, Pixel ac)
{
  Display *disp = XtDisplay(widget_id);
  int scr = DefaultScreen(disp);
  Window root = DefaultRootWindow(disp);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_POINT, point_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_LINE, line_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_BRUSHOPT, brushopt_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_CIRCLE, circle_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_PERIM, perim_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_BOXSELECT, boxselect_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_LASSOSELECT, lassoselect_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_SELECTALL, selectall_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_REPLACE, replace_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_EVERYWHERE, everywhere_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_DRAW, draw_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_POLYLINE, polyline_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_FILLOPT, fillopt_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_ELLIPSE, ellipse_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_FILLED, filled_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_ELLIPSESELECT, 
	     ellipseselect_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_COLORSELECT, colorselect_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_DESELECTALL, deselectall_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_ADD, add_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_INSIDE, inside_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_AIRBRUSH, airbrush_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_FILL, fill_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_COLOREXT, colorext_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_BOX, box_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_FILLEDPERIM, filledperim_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_POLYGONSELECT, 
	     polygonselect_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_SHOWMASK, showmask_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_CLONE, clone_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_SUBSTRACT, substract_bits);
  add_pixmap(disp, root, scr, fg, bg, ac, TB_OUTSIDE, outside_bits);
}



/* FUNCTION:       add_pixmap(Display *disp, Window root, int scr, Pixel fg, 
                              Pixel bg, Pixel ac, int index, char bits[])
   DESCRIPTION:    Adds two pixmaps to the array.
   PARAMETERS:
   Display *disp   Pointer to display structure.
   Window win      Toolbox window.
   int scr         Screen number.
   Pixel fg        Foreground color.
   Pixel bg        Background color.
   Pixel ac        Arm color.
   int index       Index to the pixmap array.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 10th August 1993.
*/   
void add_pixmap(Display *disp, Window root, int scr, Pixel fg, Pixel bg,
		Pixel ac, int index, char bits[])
{
  /* normal button pixmap */
  tool_bmps[index] =
    XCreatePixmapFromBitmapData(disp, root, bits, PIXMAP_WIDTH, PIXMAP_HEIGHT,
				fg, bg, DefaultDepth(disp, scr));
  /* pixmap of a depressed button */
  tool_bmps[index+NO_PIXMAPS] =
    XCreatePixmapFromBitmapData(disp, root, bits, PIXMAP_WIDTH, PIXMAP_HEIGHT,
				fg, ac, DefaultDepth(disp, scr));
}












