 /*
  * Khoros: $Id: cleanup.c,v 1.1 1991/05/10 15:56:26 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: cleanup.c,v 1.1 1991/05/10 15:56:26 khoros Exp $";
#endif

 /*
  * $Log: cleanup.c,v $
 * Revision 1.1  1991/05/10  15:56:26  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "forms.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	           Form Deletion/Cleanup Routines             <<<<
   >>>>                                                       <<<<
   >>>>                xvf_destroy_form()                     <<<<
   >>>>                xvf_destroy_subform()                  <<<<
   >>>>                                                       <<<<
   >>>>                xvf_delete_live_sels()                 <<<<
   >>>>                xvf_delete_live_sel_link()             <<<<
   >>>>                                                       <<<<
   >>>>                xvf_delete_int_scrolls()               <<<<
   >>>>                xvf_delete_int_scroll_link()           <<<<
   >>>>                                                       <<<<
   >>>>                xvf_delete_float_scrolls()             <<<<
   >>>>                xvf_delete_float_scroll_link()         <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/************************************************************
*
*  Routine Name: xvf_destroy_form
*
*      Purpose:  destroys the form tree associated with the form pointer
*		 returned by xvf_create_form.  To  be used only when
*		 the application program is totally finished with the
*		 form.  Frees up memory associated with the form tree.
*
*        Input: formptr - the form pointer
*
*       Output: none
*
*    Called By: user application
*
*   Written By: Danielle Argiro
*
*
*************************************************************/

xvf_destroy_form(formptr)

xvf_form *formptr;
{
	xvf_sub_form *subform, *old_subform;

	if (formptr == NULL) return;

	subform = formptr->subform;
	while(subform != NULL)
	{
	   old_subform = subform;
	   subform = subform->next_subform;
	   xvf_destroy_subform(old_subform);
	}
	xvf_free_database(formptr->db);
	xvf_delete_entry(formptr);

	if (formptr->toplevel != NULL)
	{
	   if (XtIsRealized(formptr->toplevel))
	      XtDestroyWidget(formptr->toplevel);
	}


 	if (formptr->toplevel_name != NULL)
	   free(formptr->toplevel_name);
 	if (formptr->back_name != NULL)
	   free(formptr->back_name);
 	if (formptr->label_name != NULL)
	   free(formptr->label_name);

 	if (formptr->form_name != NULL)
	   free(formptr->form_name);

 	if (formptr->update != NULL)
	   free(formptr->update);

 	if (formptr->glyph_toplevel != NULL)
	{
	   if (XtIsRealized(formptr->glyph_toplevel))
	      XtDestroyWidget(formptr->glyph_toplevel);
	}

 	if (formptr->glyph_top_name != NULL)
	   free(formptr->glyph_top_name);

	
	xvf_delete_live_sels(formptr);
	xvf_delete_int_scrolls(formptr);
	xvf_delete_float_scrolls(formptr);

        xvf_toplevels     = NULL;

	free(formptr);
}




/************************************************************
*
*  Routine Name: xvf_destroy_subform
*
*      Purpose:  destroys the subform tree associated with the subform
*		 pointer.  To  be used only when the application program 
*		 totally finished with the subform.  Frees up memory
*		 associated with the form tree
*
*        Input: subform - the subform pointer
*
*       Output: none
*
*    Called By: user application
*
*   Written By: Danielle Argiro and Mark Young
*
*
*************************************************************/

xvf_destroy_subform(subform)

xvf_sub_form *subform;
{
	xvf_selection *sel, *old_sel, *toggle, *old_toggle;
	xvf_guide_button *old_guide, *guide;
	xvf_pane *pane;

	if (subform == NULL)
	   return;

	if (subform->toplevel != NULL)
	{
	   if (XtIsRealized(subform->toplevel))
	      XtDestroyWidget(subform->toplevel);
	}

	guide = subform->guide_button;
	while (guide != NULL)
	{
	   if (guide->button_name != NULL)
	      free(guide->button_name);
	   if (guide->pane != NULL) 
	   {
	      pane = guide->pane;
	      if (pane->label_name != NULL)
	         free (pane->label_name);
	      if (pane->back_name != NULL)
	         free (pane->back_name);
	      if (pane->guide_button_name != NULL)
	         free (pane->guide_button_name);
	       sel = pane->sel_list;
	       while (sel != NULL)
	       {
		  if (sel->value_name != NULL)
		     free(sel->value_name);
		  if (sel->opt_name != NULL)
		     free(sel->opt_name);
		  if (sel->label_name != NULL)
		     free(sel->label_name);
		  if (sel->back_name != NULL)
		     free(sel->back_name);
		  toggle = sel->toggle_next;
		  while (toggle != NULL)
		  {
		     if (toggle->value_name != NULL)
			free(toggle->value_name);
		     if (toggle->opt_name != NULL)
			free(toggle->opt_name);
		     if (toggle->label_name != NULL)
		        free(toggle->label_name);
		     if (toggle->back_name != NULL)
		        free(toggle->back_name);
		     if (toggle->buffer != NULL)
		        free(toggle->buffer);
		     old_toggle = toggle;
		     toggle = toggle->next;
		     if (old_toggle != NULL)
		        free(old_toggle);
		  }
		  old_sel = sel;
		  sel = sel->next;
		  if (old_sel != NULL)
		     free(old_sel);
	       }
	       if (pane != NULL)
		  free(pane);
	   }
	   old_guide = guide;
	   guide = guide->next_button;
	   if (old_guide != NULL)
	      free(old_guide);
	}

 	if (subform->glyph_toplevel != NULL)
	{
	   if (XtIsRealized(subform->glyph_toplevel))
	      XtDestroyWidget(subform->glyph_toplevel);
	}
	free(subform);
}

/************************************************************
*
*  Routine Name: xvf_delete_live_sels()
*
*      Purpose:  when xvf_destroy_form() is called, deletes 
*		 any live selections listed in the live_sel_list
*		 associated with the form being destroyed.
*		
*        Input:  form - the formptr being destroyed
*
*       Output:  none
*
*   Written By:  Danielle Argiro 
*
*************************************************************/

xvf_delete_live_sels(form)
xvf_form *form;
{
        xvf_live_sel_link *live_sel_ptr, *tmp;

        if (live_sel_list == NULL) return;

	live_sel_ptr = live_sel_list;

	while (live_sel_ptr != NULL)
	{
	    tmp = live_sel_ptr->next;
	    if (live_sel_ptr->live_data->formptr == form)
		xvf_delete_live_sel_link(live_sel_ptr);
	    live_sel_ptr = tmp;
	}
}

/************************************************************
*
*  Routine Name: xvf_delete_live_sel_link()
*
*      Purpose:  deletes a node from the live_sel_list.
*		
*        Input:  old_live_sel_ptr - pointer to node to be deleted
*
*       Output:  none
*
*   Written By:  Danielle Argiro 
*
*************************************************************/

xvf_delete_live_sel_link(old_live_sel_ptr)
xvf_live_sel_link *old_live_sel_ptr;
{
	xvf_live_sel_link *last;

	/* deleting first node in the list */
	if (old_live_sel_ptr == live_sel_list)
	{
	    live_sel_list = live_sel_list->next;
	    free(old_live_sel_ptr->live_data);
	    free(old_live_sel_ptr);
	    return;
	}

	last = live_sel_list;

	while (last->next != old_live_sel_ptr)
	    last = last->next;

	last->next = old_live_sel_ptr->next;
	free(old_live_sel_ptr->live_data);
        free(old_live_sel_ptr);
}


/************************************************************
*
*  Routine Name: xvf_delete_int_scrolls()
*
*      Purpose:  when xvf_destroy_form() is called, deletes 
*		 any integer scrollbars listed in the 
*		 int_scroll_list
*		
*		 associated with the form being destroyed.
*		
*        Input:  form - the formptr being destroyed
*
*       Output:  none
*
*   Written By:  Danielle Argiro 
*
*************************************************************/

xvf_delete_int_scrolls(form)
xvf_form *form;
{
	xvf_int_scroll_link *int_scroll_ptr, *tmp;

        if (int_scroll_list == NULL) return;

	int_scroll_ptr = int_scroll_list;

	while (int_scroll_ptr != NULL)
	{
	    tmp = int_scroll_ptr->next;
	    if (int_scroll_ptr->scroll_info->formptr == form)
		xvf_delete_int_scroll_link(int_scroll_ptr);
	    int_scroll_ptr = tmp;
	}
}

/************************************************************
*
*  Routine Name: xvf_delete_int_scroll_link()
*
*      Purpose:  deletes a node from the int_scroll_list.
*		
*        Input:  old_int_scroll_link - pointer to node to be deleted
*
*       Output:  none
*
*   Written By:  Danielle Argiro 
*
*************************************************************/

xvf_delete_int_scroll_link(old_int_scroll_link)
xvf_int_scroll_link *old_int_scroll_link;
{
	xvf_int_scroll_link *last;

	/* deleting first node in the list */
	if (old_int_scroll_link == int_scroll_list)
	{
	    int_scroll_list = int_scroll_list->next;
	    free(old_int_scroll_link->scroll_info);
	    free(old_int_scroll_link);
	    return;
	}

	last = int_scroll_list;

	while (last->next != old_int_scroll_link)
	    last = last->next;

	last->next = old_int_scroll_link->next;
	free(old_int_scroll_link->scroll_info);
        free(old_int_scroll_link);
}


/************************************************************
*
*  Routine Name: xvf_delete_float_scrolls()
*
*      Purpose:  when xvf_destroy_form() is called, deletes 
*		 any float scrollbars listed in the 
*		 float_scroll_list
*		
*		 associated with the form being destroyed.
*		
*        Input:  form - the formptr being destroyed
*
*       Output:  none
*
*   Written By:  Danielle Argiro 
*
*************************************************************/

xvf_delete_float_scrolls(form)
xvf_form *form;
{
	xvf_float_scroll_link *float_scroll_ptr, *tmp;

        if (float_scroll_list == NULL) return;

	float_scroll_ptr = float_scroll_list;

	while (float_scroll_ptr != NULL)
	{
	    tmp = float_scroll_ptr->next;
	    if (float_scroll_ptr->scroll_info->formptr == form)
		xvf_delete_float_scroll_link(float_scroll_ptr);
	    float_scroll_ptr = tmp;
	}
}

/************************************************************
*
*  Routine Name: xvf_delete_float_scroll_link()
*
*      Purpose:  deletes a node from the float_scroll_list.
*		
*        Input:  old_float_scroll_link - pofloater to node to be deleted
*
*       Output:  none
*
*   Written By:  Danielle Argiro 
*
*************************************************************/

xvf_delete_float_scroll_link(old_float_scroll_link)
xvf_float_scroll_link *old_float_scroll_link;
{
	xvf_float_scroll_link *last;

	/* deleting first node in the list */
	if (old_float_scroll_link == float_scroll_list)
	{
	    float_scroll_list = float_scroll_list->next;
	    free(old_float_scroll_link->scroll_info);
	    free(old_float_scroll_link);
	    return;
	}

	last = float_scroll_list;

	while (last->next != old_float_scroll_link)
	    last = last->next;

	last->next = old_float_scroll_link->next;
	free(old_float_scroll_link->scroll_info);
        free(old_float_scroll_link);
}

