 /*
  * Khoros: $Id: vpolygon.c,v 1.3 1992/03/20 23:12:19 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vpolygon.c,v 1.3 1992/03/20 23:12:19 dkhoros Exp $";
#endif

 /*
  * $Log: vpolygon.c,v $
 * Revision 1.3  1992/03/20  23:12:19  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vpolygon.c
 >>>>
 >>>>      Program Name: vpolygon
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Creates  a  vector  image   resulting   from   a   polygonal
 >>>>	approximation of an edge image.
 >>>>	
 >>>>	

 >>>>            Author: Jean-Pierre COCQUEREZ, Marc VIALA, Pascal ADAM
 >>>>
 >>>> Date Last Updated: Thu Mar 12 09:36:27 1992
 >>>>
 >>>>          Routines: main- the main program for vpolygon
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vpolygon.h"


/****************************************************************
 *
 * Routine Name:  main program for vpolygon
 *
 *       Input:  
 *          -i  Edge Image 
 *          -o1  Vector Image Resulting from the Polygonal Approximation 
 *
 *
 *          [-o2] Output Image Containing the Polygonal Edge Approximation
 *          [-l] Minimal Length For Segment Extraction  (value > 0)
 *          [-p] Percentage of Segment Rejected  (0.000 < value < 1.000)
 *          [-t] Threshold Value for the Approximation  (value > 0.0)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage       *image,
                     *vector,
                     *readimage();
void                 drawligne();

/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */

    /* Read the input image */
    READINPUT (image,vpolygon->i_file);

    /* Test input image */
    propertype(program, image, VFF_TYP_1_BYTE, TRUE);
    proper_loc_type(program, image, VFF_LOC_IMPLICIT, TRUE);
    proper_num_images(program, image, 1, TRUE);
    proper_num_bands(program, image, 1, TRUE);
    proper_map_scheme(program, image, VFF_MS_NONE, TRUE);

/* -main_before_lib_call_end */

/* -main_library_call */
if (lvpolygon(image,&vector,vpolygon->t_float,vpolygon->p_float,vpolygon->l_int))
{
   (void) fprintf(stderr,"lvpolygon: Failed\n\n");
   exit(1);
}
/* -main_library_call_end */

/* -main_after_lib_call */
    /* save vector image */
    SAVEOUTPUT(vector,vpolygon->o1_file);

    if (vpolygon->o2_flag == TRUE)
    {
       SAVEOUTPUT(image,vpolygon->o2_file);
    }

/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vpolygon 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vpolygon :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCreates  a  vector  image   resulting   from   a   polygonal\n");
	fprintf(stderr, "\tapproximation of an edge image.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  Edge Image  (infile)\n");
	fprintf(stderr,"\t-o1  Vector Image Resulting from the Polygonal Approximation  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-o2]  Output Image Containing the Polygonal Edge Approximation (outfile) [null]\n");
	fprintf(stderr,"\t[-l]  Minimal Length For Segment Extraction (integer, > 0) [10]\n");
	fprintf(stderr,"\t[-p]  Percentage of Segment Rejected (float,  0.000 to 1.000) [0.1]\n");
	fprintf(stderr,"\t[-t]  Threshold Value for the Approximation (float, > 0.0) [0.6]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vpolygon\n");
	fprintf(stderr, "\t[-U] Gives the usage for vpolygon\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vpolygon.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vpolygon.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vpolygon
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) Edge Image \n        {infile}: "; 
char	*o1_pstr = 
	"\nEnter: (o1) Vector Image Resulting from the Polygonal Approximation \n        {outfile}: "; 
char	*o2_pstr = 
	"\nEnter: (o2) Output Image Containing the Polygonal Edge Approximation \n        {outfile}: "; 
char	*l_pstr = 
	"\nEnter: (l) Minimal Length For Segment Extraction \n        {integer, > 0 [10] }: "; 
char	*p_pstr = 
	"\nEnter: (p) Percentage of Segment Rejected \n        {float,  0.000 to 1.000 [0.100000] }: "; 
char	*t_pstr = 
	"\nEnter: (t) Threshold Value for the Approximation \n        {float, > 0.0 [0.600000] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vpolygon", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vpolygon.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vpolygon: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vpolygon.ans");
		}

	     }

	}

	/*
	 * allocate the vpolygon structure
	 */
	vpolygon = (vpolygon_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vpolygon_struct));

	/*
	 * get required arguments for vpolygon
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vpolygon->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vpolygon->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vpolygon->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vpolygon->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vpolygon->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vpolygon->o1_flag = vget_outfile(fid, prompt_flag,
			"-o1", o1_pstr, &(vpolygon->o1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vpolygon->o1_flag))
		{
		    fprintf(stderr, "\t\to1 is required, please re-enter: \n");
		    vpolygon->o1_flag = vget_outfile(fid, prompt_flag,
		    "-o1", o1_pstr, &(vpolygon->o1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vpolygon
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vpolygon->o2_flag = vget_outfile(fid, prompt_flag,
	"-o2", o2_pstr, &(vpolygon->o2_file))
;

	vpolygon->l_flag = vget_int(fid, prompt_flag,
	"-l", l_pstr, &(vpolygon->l_int),
	10, 2, 2);

	vpolygon->p_flag = vget_float(fid, prompt_flag,
	"-p", p_pstr, &(vpolygon->p_float),
	0.100000, 0.000000, 1.000000);

	vpolygon->t_flag = vget_float(fid, prompt_flag,
	"-t", t_pstr, &(vpolygon->t_float),
	0.600000, 2.000000, 2.000000);


}



