 /*
  * Khoros: $Id: vcrgbhsv.c,v 1.1 1991/05/10 15:46:36 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vcrgbhsv.c,v 1.1 1991/05/10 15:46:36 khoros Exp $";
#endif

 /*
  * $Log: vcrgbhsv.c,v $
 * Revision 1.1  1991/05/10  15:46:36  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vcrgbhsv.c
 >>>>
 >>>>      Program Name: vcrgbhsv
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Conversion between NTSC RGB and HSV color spaces.
 >>>>	
 >>>>	
 >>>>            Author: Tom Sauer
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:22:11 1991
 >>>>
 >>>>          Routines: main- the main program for vcrgbhsv
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vcrgbhsv.h"


/****************************************************************
 *
 * Routine Name:  main program for vcrgbhsv
 *
 *       Input:  
 *          -i  input image filename 
 *          -o  output image filename 
 *
 *
 *          [-n] normalization factor  (value > 0.0)
 *          [-h] Convert (RGB to HSV) [True] or (HSV to RGB) [False]
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *img1, *readimage ();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);
READINPUT (img1);
CHECKINPUT (program, img1);
CHECKMODEL (program, img1, vcrgbhsv);
/* -main_before_lib_call_end */

/* -main_library_call */
if(! lvcrgbhsv(img1,vcrgbhsv->h_logic, vcrgbhsv->h_flag,vcrgbhsv->n_float,vcrgbhsv->n_flag))
 {
   (void) fprintf(stderr, "lvcrgbhsv Failed\n");
   exit(1);
 }
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(vcrgbhsv->o_file,img1);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vcrgbhsv 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vcrgbhsv :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tConversion between NTSC RGB and HSV color spaces.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image filename  (infile)\n");
	fprintf(stderr,"\t-o  output image filename  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-n]  normalization factor (float, > 0.0) [255]\n");
	fprintf(stderr,"\t[-h]  Convert (RGB to HSV) [True] or (HSV to RGB) [False] (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vcrgbhsv\n");
	fprintf(stderr, "\t[-U] Gives the usage for vcrgbhsv\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vcrgbhsv.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vcrgbhsv.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vcrgbhsv
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image filename \n        {outfile}: "; 
char	*n_pstr = 
	"\nEnter: (n) normalization factor \n        {float, > 0.0 [255.000000] }: "; 
char	*h_pstr = 
	"\nEnter: (h) Convert (RGB to HSV) [True] or (HSV to RGB) [False] \n        {boolean, (y/n)  [yes] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vcrgbhsv", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vcrgbhsv.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vcrgbhsv: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vcrgbhsv.ans");
		}

	     }

	}

	/*
	 * allocate the vcrgbhsv structure
	 */
	vcrgbhsv = (vcrgbhsv_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vcrgbhsv_struct));

	/*
	 * get required arguments for vcrgbhsv
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vcrgbhsv->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vcrgbhsv->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vcrgbhsv->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vcrgbhsv->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vcrgbhsv->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vcrgbhsv->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vcrgbhsv->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vcrgbhsv->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vcrgbhsv->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vcrgbhsv->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vcrgbhsv
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vcrgbhsv->n_flag = vget_float(fid, prompt_flag,
	"-n", n_pstr, &(vcrgbhsv->n_float),
	255.000000, 2.000000, 2.000000);

	vcrgbhsv->h_flag = vget_logic(fid, prompt_flag,
	"-h", h_pstr, &(vcrgbhsv->h_logic), 1);


}



