 /*
  * Khoros: $Id: lvlshift.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvlshift.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvlshift.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvlshift.c
 >>>>
 >>>>      Program Name: vlshift
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:54:24 1991 
 >>>>
 >>>>          Routines: lvlshift - the library call for vlshift
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvlshift - library call for vlshift
*
* Purpose:
*    
*    Left shift each pixel value in an image.
*    
*    
* Input:
*    
*         img1 -- input image xvimage structure
*         img2 -- mask image for gating operation
*         mflg -- indicates that the mask image should be
*                 used
*         s -- number of bit positions to shift pixel data left
*    
*         The input images must be of the same data type and size.
*    
*    
* Output:
*    
*         1. img1 -- output xvimage structure
*    
*         img1 is used for both the input xvimage  structure  and  the
*         output  result  xvimage  structure.   This  is  done to save
*         space, but you must be careful not  to  overwrite  important
*         data.
*    
*         lvlshift returns 1 upon success and 0 on failure.
*    
*    
*
* Written By: Scott Wilson
*    
*    Marcelo Teran, John Rasure, Tom Sauer
*    
*    
****************************************************************/


/* -library_def */
int
lvlshift(img1,img2,mflg,s)
struct xvimage *img1,*img2;
int  mflg, s;
/* -library_def_end */

/* -library_code */
{
    int    j, k;
    int    *i1,*i2,*i3;
    short  *s1,*s2,*s3;
    unsigned char *c1,*c2,*c3;

         /* Normal operation count */
    k = img1->row_size*img1->col_size * img1->num_data_bands; 
    switch (img1->data_storage_type)
      {
        case VFF_TYP_BIT :
          fprintf(stderr,"lvlshift: Don't know how to shift BIT images\n");
          return(0);
          break;
        case VFF_TYP_1_BYTE : 
          c1 = (unsigned char *)(img1->imagedata);
          c2 = (unsigned char *)(img1->imagedata);
          if (mflg) c3 = (unsigned char *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++) *c2++ = *c1++ << s;
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*c3++) *c2++ = *c1++ << s;
                  else
                    {
                      c1++; c2++;
                    }
                }
            }
          break;
        case VFF_TYP_2_BYTE :
          s1 = (short *)(img1->imagedata);
          s2 = (short *)(img1->imagedata);
          if (mflg) s3 = (short *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++) *s2++ = *s1++ << s;
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*s3++) *s2++ = *s1++ << s;
                  else
                    {
                      s1++; s2++;
                    }
                }
            }
          break;
        case VFF_TYP_4_BYTE :
          i1 = (int *)(img1->imagedata);
          i2 = (int *)(img1->imagedata);
          if (mflg) i3 = (int *)(img2->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++) *i2++ = *i1++ << s;
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*i3++) *i2++ = *i1++ << s;
                  else
                    {
                      i1++; i2++;
                    }
                }
            }
          break;
        case VFF_TYP_FLOAT :
          fprintf(stderr,"lvlshift: Don't know how to shift a FLOAT\n");
          return(0);
          break;
        case VFF_TYP_COMPLEX :
          fprintf(stderr,"lvlshift: Don't know how to shift a COMPLEX\n");
          return(0);
          break;
        default:
          fprintf(stderr,"lvlshift: Unknown data storage type, %d\n",img1->data_storage_type);
          return(0);
          break;
      }
      return(1);
}
/* -library_code_end */
