 /*
  * Khoros: $Id: lvinsert.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvinsert.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvinsert.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvinsert.c
 >>>>
 >>>>      Program Name: vinsert
 >>>>
 >>>> Date Last Updated: Thu Mar  7 15:56:06 1991 
 >>>>
 >>>>          Routines: lvinsert - the library call for vinsert
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvinsert - library call for vinsert
*
* Purpose:
*    
*    Insert a (sub)image into another image.
*    
*    
* Input:
*    
*    img1           input xvimage structure
*    
*    img2           input xvimage structure for subimage
*    
*    xoff           specifies the upper  left  X  coordinate  for  the
*                   placement of the subimage.
*    
*    yoff           specifies the upper  left  Y  coordinate  for  the
*                   placement of the subimage.
*    
*    real           specifies the real value for padding
*    
*    imag           specifies the imaginary  value  for  padding  with
*                   COMPLEX
*    
*    
* Output:
*    
*    img1           holds the result of  the  insert  operation.   The
*                   output  data  type  is  the same as the input data
*                   type.
*    
*    
*
* Written By: John Rasure, Tom Sauer, Mark Young
*    
*    
****************************************************************/


/* -library_def */
int
lvinsert(img1,img2,xoff,yoff, real, imag)

struct  xvimage *img1,*img2;
int     xoff,yoff;
float   real, imag;
/* -library_def_end */

/* -library_code */
{
        struct   xvimage *img;
        char     *cptr1, *cptr2;
        int      i, j, bands, width, height, rows, cols, new_rows, new_cols;
        int      rsize, nsize, isize, row_size, nrow_size, irow_size, xoffset;
        char     *program = "lvinsert";


        height = img2->col_size;
        width  = img2->row_size;
        rows = img1->col_size;
        cols = img1->row_size;
        bands  = img1->num_data_bands;

        new_cols = cols;
        new_rows = rows;
        if (xoff+width > cols) 
           new_cols = xoff+width;

        if (yoff+height > rows)
           new_rows = yoff+height;

        row_size  = viff_rowsize(img1->data_storage_type, cols);
        nrow_size = viff_rowsize(img1->data_storage_type, new_cols);
        irow_size = viff_rowsize(img1->data_storage_type, width);
        xoffset   = viff_rowsize(img1->data_storage_type, xoff);

        /*
         *  If we need to create a larger image then call "lvgconst" to create
         *  an image of size new_cols by new_rows.
         */
        if (new_cols > cols || new_rows > rows)
        {
           if (! lvgconst(&img, new_rows, new_cols, img1->data_storage_type,
                          real, imag, bands)) 
           {
              (void) fprintf(stderr, "%s: Create a constant image failed\n",
                             program);
              return(0);
           }

           rsize = row_size*rows;
           nsize = nrow_size*new_rows;
           for (i = 0; i < bands; i++)
           {
              cptr1 = img1->imagedata + rsize*i;
              cptr2 = img->imagedata  + nsize*i;
              for (j = 0; j < rows; j++)
              {
                 bcopy(cptr1, cptr2, row_size);
                 cptr1 += row_size;
                 cptr2 += nrow_size;
              }
           }
           free(img1->imagedata);
           img1->imagedata = img->imagedata;
           img1->row_size = img->row_size;
           img1->col_size = img->col_size;
           free(img);
        }

        /*
         *  Now it's time to insert the insert image "img2" into img1.
         */
        isize = irow_size*height;
        nsize = nrow_size*new_rows;
        for (i = 0; i < bands; i++)
        {
            cptr1 = img2->imagedata + isize*i;
            cptr2 = img1->imagedata + nsize*i + yoff*nrow_size + xoffset;
            for (j = 0; j < height; j++)
            {
                bcopy(cptr1, cptr2, irow_size);
                cptr1 += irow_size;
                cptr2 += nrow_size;
            }
        }
        return(1);
}
/* -library_code_end */
