 /*
  * Khoros: $Id: lvdistance.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvdistance.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvdistance.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvdistance.c
 >>>>
 >>>>      Program Name: vdistance
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:39:26 1991 
 >>>>
 >>>>          Routines: lvdistance - the library call for vdistance
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvdistance - library call for vdistance
*
* Purpose:
*    
*    Computes the distance from the boundary in a two_valued byte
*    image.
*    
*    
* Input:
*    
*         image _ structure xvimage.
*    
*    
* Output:
*    
*         image _ holds the result.
*    
*    
*
* Written By: Pascal ADAM
*    
*    
****************************************************************/


/* -library_def */
int
lvdistance(image)
struct xvimage *image;
/* -library_def_end */

/* -library_code */
{
    unsigned char *im0, *imk, *imkk;
    unsigned char *cptr, *cptr0, *cptrk, *cptrkk;

    int i, j, k, nc, nr;

    int fin;
    int min;
 
    char   *program = "lvdistance";

    /* Check type,... of image */
    if (!(propertype(program, image, VFF_TYP_1_BYTE, FALSE))) {
        (void) fprintf (stderr, "\n\n%s:   ", program);
        (void) fprintf (stderr, "lvmskeleton: image must be of type byte\n");
        return (0);
    }
    if (!(proper_num_images (program, image, 1, FALSE))) {
        (void) fprintf (stderr, "\n\n%s:   ", program);
        (void) fprintf (stderr, "Can only work on files with one image\n\n");
        return (0);
    }
    if (!(proper_num_bands (program, image, 1, FALSE))) {
        (void) fprintf (stderr,"\n\n%s:   ", program);
        (void) fprintf (stderr,"Can only work on images with 1 data band\n\n");
        return (0);
    }

    nr = image->col_size;
    nc = image->row_size;


    /* dynamic memory allocation for temporary im0 stockage */
    im0 = (unsigned char *) malloc( nc * nr *sizeof(unsigned char));
    if (im0 == NULL) {
        (void) fprintf (stderr, "\n%s:   ", program);
        (void) fprintf (stderr, "Insufficient Space avaliable\n");
        return(0);
    }

    /* dynamic memory allocation for temporary imk stockage */
    imk = (unsigned char *) malloc( nc * nr *sizeof(unsigned char));
    if (imk == NULL) {
        (void) fprintf (stderr, "\n%s:   ", program);
        (void) fprintf (stderr, "Insufficient Space avaliable\n");
        return(0);
    }

    /* dynamic memory allocation for temporary imkk stockage */
    imkk = (unsigned char *) malloc( nc * nr *sizeof(unsigned char));
    if (imkk == NULL) {
        (void) fprintf (stderr, "\n%s:   ", program);
        (void) fprintf (stderr, "Insufficient Space avaliable\n");
        return(0);
    }

    /* initialisation .... transforms the original byte and supposed 
    ** binary image into an image which background pixel value is 0, 
    ** and 1 for the objects, and finally stores it in im0, imk and imkk.
    */
    cptr   = (unsigned char *) image->imagedata;
    cptr0  = im0;
    cptrk  = imk;
    cptrkk = imkk;

    for (i=0;i < nc * nr; i++)
        if  (*cptr++ == 0)
            *cptr0++ = *cptrk++ = *cptrkk++ = 0; 
        else
            *cptr0++ = *cptrk++ = *cptrkk++ = 1;
 
    /* Starts the iterative process .....
    ** im0 is the original image 0 for background, 1 for the regions.
    ** imk is the image at the iteration k.
    ** imkk is the image at the iteration k-1.
    ** the iterative process can be resumed as followed:
    ** if imkk(i,j) < k (number of iterations) no action.
    ** else imk(i,j) = 1 + min ( imkk(i-1,j),imkk(i+1,j),
    **                           imkk(i,j-1),imkk(i,j+1) ) 
    ** ....
    ** imkk gets the value of imk and the iteration continue
    ** until there is no change.
    **
    */

    k = 1;
    do
    {
         fin = TRUE;

         cptrk = imk; cptrkk = imkk;

         for (i=1;i < nr-1;i++) 
         {
           for (j=1;j < nc-1;j++) 
           {
             if  (*(cptrkk+i*nc+j) == k ) 
             {
                min = *(cptrkk+(i-1)*nc+j);
                min=(min> *(cptrkk+(i+1)*nc+j)? *(cptrkk+(i+1)*nc+j):min);  
                min=(min> *(cptrkk+i*nc+j+1)  ? *(cptrkk+i*nc+j+1)  :min);
                min=(min> *(cptrkk+i*nc+j-1)  ? *(cptrkk+i*nc+j-1)  :min);
    
                if (min == k)
                {                 
                   *(cptrk+i*nc+j) = min + 1;
                   fin = FALSE; 
                 } 
             }
           }                    
         }
         k ++;    /* next iteration */
  
         /* store imk in imkk for next iteration */ 
         cptrk = imk; cptrkk = imkk;
         for (i=0;i< nc*nr;i++) if (*cptrk++ == k) *(cptrkk+i) = k;

   } while (fin == FALSE); 

   /* writes final result in image->imagedata structure */
   cptr = (unsigned char *)image->imagedata;
   cptrk = imk;
   for (i=0; i < nc*nr; i++) *cptr++ = *cptrk++;

   /* free tempory space memory allocation */
   (void)free(im0);(void)free(imk);(void)free(imkk);

   return(1);
        
}
/* -library_code_end */
