 /*
  * Khoros: $Id: lvcomment.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvcomment.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvcomment.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvcomment.c
 >>>>
 >>>>      Program Name: vcomment
 >>>>
 >>>> Date Last Updated: Wed Apr  3 10:57:57 1991 
 >>>>
 >>>>          Routines: lvcomment - the library call for vcomment
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvcomment - library call for vcomment
*
* Purpose:
*    
*    changes the comment field on an VIFF/XVPFF file via keyboard
*    entry.
*    
*    
* Input:
*    
*         *desc - header comment field
*    
*    
* Output:
*    
*         the comment field of the Khoros File
*    
*    
*
* Written By: Ron E. Neher
*    
*    Ghosted by Pascal Adam , Mon Jun 18, 1990
*    
*    
****************************************************************/


/* -library_def */
int
lvcomment(desc)
char    *desc;
/* -library_def_end */

/* -library_code */
{
        FILE    *vifile, *fopen();
        int     size;
        char    *tmp_file = "/tmp/Khoros.XXXXXX",
                *filename, buff[LENGTH], buff1[LENGTH];

        filename = vtempnam(tmp_file);

        if ((vifile = fopen(filename, "w")) == NULL)
        {
           (void) fprintf(stderr, "lvcomment: can not create %s for editing\n",
                          filename);
           return(0);
        }

        (void) fprintf(vifile, "%s", desc);
        (void) fclose(vifile);


        veditfile(filename);
        if ((vifile = fopen(filename, "r")) == NULL)
        {
           (void)fprintf(stderr, "lvcomment: can not read %s file\n", filename);
           return(0);
        }

        buff[0] = '\0';
        size = 0;
        while (fgets(buff1, LENGTH, vifile) != NULL && size < LENGTH)
        {
           size += VStrlen(buff1);
           if (size < LENGTH)
           {
              (void) strncat(buff, buff1, VStrlen(buff1));
           }
           else
           {
              (void) strncat(buff, buff1, size - LENGTH - 1);
           }
        }
        (void) fclose(vifile);

        (void) strncpy(desc, buff, LENGTH - 1);
        (void) strncat(desc, "", 1);
        (void) unlink(filename);
        free(filename);

        return(1);
}
/* -library_code_end */
