 /*
  * Khoros: $Id: viff2fits.h,v 1.1 1991/05/10 15:53:06 khoros Exp $
  */

 /*
  * $Log: viff2fits.h,v $
 * Revision 1.1  1991/05/10  15:53:06  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: viff2fits.h
 >>>>            Author: Robin Corbet, PSU
 >>>> Date Last Updated: Sat Mar  2 14:40:35 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _viff2fits_h_
#define _viff2fits_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    viff2fits Argument Structure
*
****************************************************************/

typedef struct _viff2fits  {

/*
 *  input VIFF data file (Required infile)
 */
char	*i_file;	/* input VIFF data file FILENAME */
int	 i_flag;	/* input VIFF data file FLAG */

/*
 *  resulting output image (FITS file) (Required outfile)
 */
char	*o_file;	/* resulting output image (FITS file) FILENAME */
int	 o_flag;	/* resulting output image (FITS file) FLAG */

}  viff2fits_struct;

viff2fits_struct *viff2fits;

/* -include_additions */
#include "file_formats/fits.h"
/* -include_additions_end */

/* -include_macros */
#define READINPUT(viff_image) \
    viff_image = readimage(viff2fits->i_file); \
    if(viff_image == NULL) { \
        (void) fprintf(stderr,"viff2fits: Image could not be read\n"); \
        exit(1); \
    }
#define CHECKINPUT(program, viff_image) \
        (void) proper_num_images(program,viff_image,1,TRUE); \
        (void) proper_map_enable(program,viff_image,VFF_MAP_OPTIONAL,TRUE); \
/* -include_macros_end */

#endif
