 /*
  * Khoros: $Id: rast2viff.c,v 1.1 1991/05/10 15:52:59 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: rast2viff.c,v 1.1 1991/05/10 15:52:59 khoros Exp $";
#endif

 /*
  * $Log: rast2viff.c,v $
 * Revision 1.1  1991/05/10  15:52:59  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: rast2viff.c
 >>>>
 >>>>      Program Name: rast2viff
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	converts a SUN raster image to the VIFF image format
 >>>>	
 >>>>	
 >>>>            Author: Tom Sauer
 >>>>
 >>>> Date Last Updated: Sat Mar  2 14:34:55 1991
 >>>>
 >>>>          Routines: main- the main program for rast2viff
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "rast2viff.h"


/****************************************************************
 *
 * Routine Name:  main program for rast2viff
 *
 *       Input:  
 *           -i  input Raster image file 
 *           -o  resulting output image (viff file) 
 *
 *
 *           [-p] if yes, invert image (photonegative); if no (default) do not invert image (photopositive)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *viff_image;
struct rast *read_rast(), *rast_image;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
       if (check_args()) exit(1);

        rast_image = read_rast(rast2viff->i_file);
        if (rast_image == NULL)
        {
            (void) fprintf(stderr,"rast2viff: Could not read input image.\n");
            exit(1);

        }
/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lrast2viff(rast_image, &viff_image, rast2viff->p_logic))
    {
         (void) fprintf(stderr, "lrast2viff Failed.\n");
         exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(rast2viff->o_file, viff_image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for rast2viff 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "rast2viff :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tconverts a SUN raster image to the VIFF image format\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input Raster image file  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image (viff file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-p]  if yes, invert image (photonegative); if no (default) do not invert image (photopositive) (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for rast2viff\n");
	fprintf(stderr, "\t[-U] Gives the usage for rast2viff\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called rast2viff.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses rast2viff.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for rast2viff
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input Raster image file \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image (viff file) \n        {outfile}: "; 
char	*p_pstr = 
	"\nEnter: (p) if yes, invert image (photonegative); if no (default) do not invert image (photopositive) \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "rast2viff", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "rast2viff.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "rast2viff: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "rast2viff.ans");
		}

	     }

	}

	/*
	 * allocate the rast2viff structure
	 */
	rast2viff = (rast2viff_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (rast2viff_struct));

	/*
	 * get required arguments for rast2viff
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(rast2viff->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(rast2viff->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(rast2viff->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    rast2viff->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(rast2viff->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(rast2viff->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(rast2viff->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(rast2viff->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    rast2viff->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(rast2viff->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for rast2viff
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	rast2viff->p_flag = vget_logic(fid, prompt_flag,
	"-p", p_pstr, &(rast2viff->p_logic), 0);


}



