 /*
  * Khoros: $Id: elas2viff.h,v 1.1 1991/05/10 15:52:43 khoros Exp $
  */

 /*
  * $Log: elas2viff.h,v $
 * Revision 1.1  1991/05/10  15:52:43  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: elas2viff.h
 >>>>            Author: Charlie Gage
 >>>> Date Last Updated: Sat Mar  2 14:22:05 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _elas2viff_h_
#define _elas2viff_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    elas2viff Argument Structure
*
****************************************************************/

typedef struct _elas2viff  {

/*
 *  input ELAS data file (Required infile)
 */
char	*i_file;	/* input ELAS data file FILENAME */
int	 i_flag;	/* input ELAS data file FLAG */

/*
 *  resulting output image (viff file) (Required outfile)
 */
char	*o_file;	/* resulting output image (viff file) FILENAME */
int	 o_flag;	/* resulting output image (viff file) FLAG */

/*
 *  band number (Optional integer)
 */
int	 b_int; 	/* band number INT */
int	 b_flag;	/* band number FLAG */

/*
 *  upper left x coordinate (Optional integer)
 */
int	 x_int; 	/* upper left x coordinate INT */
int	 x_flag;	/* upper left x coordinate FLAG */

/*
 *  upper left y coordinate (Optional integer)
 */
int	 y_int; 	/* upper left y coordinate INT */
int	 y_flag;	/* upper left y coordinate FLAG */

/*
 *  width (Optional integer)
 */
int	 w_int; 	/* width INT */
int	 w_flag;	/* width FLAG */

/*
 *  height (Optional integer)
 */
int	 h_int; 	/* height INT */
int	 h_flag;	/* height FLAG */

/*
 * select color space model (Optional integer toggle - )
 */
int	 c_toggle;		/* select color space model INT TOGGLE */
int	 c_flag;		/* select color space model FLAG */

}  elas2viff_struct;

elas2viff_struct *elas2viff;

/* -include_additions */
#include "file_formats/elas.h"
/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
