 /*
  * Khoros: $Id: lxbm2viff.c,v 1.3 1991/12/18 09:50:14 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lxbm2viff.c,v 1.3 1991/12/18 09:50:14 dkhoros Exp $";
#endif

 /*
  * $Log: lxbm2viff.c,v $
 * Revision 1.3  1991/12/18  09:50:14  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lxbm2viff.c
 >>>>
 >>>>      Program Name: xbm2viff
 >>>>
 >>>> Date Last Updated: Thu Nov 14 23:16:28 1991 
 >>>>
 >>>>          Routines: lxbm2viff - the library call for xbm2viff
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lxbm2viff - library call for xbm2viff
*
* Purpose:
*    
*    Converts an X11 bitmap file (xbm) to an Khoros (viff) bitmap
*    file
*    
*    

* Input:
*    
*         FILE    *file:  X11 image file.
*    
*         struct  xvimage **newimage: will return the VIFF image.
*    
*         int     photo_neg: Determines if photonegative or photoposi-
*         tive
*    
*    

* Output:
*    
*         struct  xvimage **newimage: will return the VIFF image.
*    
*    

*
* Written By: Mark Young
*    
*    Ghosted by Pascal ADAM   14-JUNE-90
*    
*    

****************************************************************/


/* -library_def */
int
lxbm2viff(file, newimage, photo_neg)

FILE    *file;
struct  xvimage **newimage;
int     photo_neg;
/* -library_def_end */

/* -library_code */
{
        unsigned char *imgdata;
        struct   xvimage *image, *createimage();
        char     line[LENGTH], name[LENGTH], comment[512], *temp;
        int      i, width, height, row, col, num, done;


        /*
         *   Initialize the width and height to be -1, so that
         *   if the user tries to give the bitmap data before
         *   defining the width or height we will know about it.
         */
        width = height = -1;
        done = FALSE;

        while (!done)
        {
           if (!fgets(line, LENGTH, file))
           {
              (void) fprintf(stderr,"lxbm2viff:  Error!  Unexpected end of \n\
file encountered.  X11 bitmap file is not of the proper format.\n");
              return(FALSE);
           }

           if (sscanf(line, "#define %s %d", name, &num) == 2)
           {
              if ((temp = strrchr(name,'_')) != NULL)
              {
                 if (strcmp(temp+1,"width") == 0)
                    width = num;
                 else if (strcmp(temp+1,"height") == 0)
                    height = num;
                 else
                    continue;

                 *temp = '\0';
              }
           }
           else if (sscanf(line, "static char %s", name) == 1)
           {
              if ((temp = strrchr(name,'_')) != NULL)
              {
                 if (strncmp(temp+1,"bits",4) == 0)
                    *temp = '\0';
                 else
                    continue;
              }

              /*
               *  Check to make sure that the width and height have been
               *  previously defined.
               */
              if (width == -1 || height == -1)
              {
                 (void) fprintf(stderr,"lxbm2viff:  Improper X11 bitmap file.  \
Both width and height have not been\ninitialized for the X11 '%s' definition.\
\n\n", name);
                 return(FALSE);
              }

              /*
               *  Otherwise we need to create our viff image and read
               *  in the bitmap data.
               */
              row = (width + 7)/8;
              col = height;

              (void) sprintf(comment, "Bitmap image created by xbm2viff from \
'%s' xbm definition.\n", name);
              image = createimage(height, width, VFF_TYP_BIT, 1, 1, comment,
                      (unsigned long)0, /* map_row_size */
                      (unsigned long)0, /* map_col_size */
                      (unsigned long)VFF_MS_NONE,
                      (unsigned long)VFF_MAPTYP_NONE,
                      (unsigned long)VFF_LOC_IMPLICIT,
                      (unsigned long)0);/* location dimension */

              if (image == NULL)
              {
                 fprintf(stderr,"lvxbm2viff:  Unable to allocate memory for \
viff image.\n");
                 return(FALSE);
              }
              imgdata = (unsigned char *) image->imagedata;

              for (i = 0; i < row*col; i++)
              {
                 if (fscanf(file," 0x%x%*[,};]", &num) == 1)
                 {
                    *imgdata++ = (unsigned char) ~num;
                 }
                 else
                 {
                    if (!fgets(line, LENGTH, file))
                    {
                       fprintf(stderr,"lxbm2viff:  Error!  Unexpected end of \n\
file encountered while reading bitmap data.  X11 bitmap file \nis not of the \
proper format.\n");
                       return(FALSE);
                    }
                    else
                    {
                       fprintf(stderr,"lxbm2viff:  Improper X11 bitmap file!\n\
Error found when reading bitmap data from the following line.\n'%s'\n", line);
                       return(FALSE);
                    }
                 }
              }
              done = TRUE;
           }
        }

        /*
         *  Check to see if the user wants to invert the final
         *  image.
         */
        if (photo_neg)
        {
           row = (image->row_size + 7)/8;
           col = image->col_size;

           imgdata = (unsigned char *) image->imagedata;
           for (i = 0; i < row*col; i++)
              *imgdata++ = ~(*imgdata);
        }
        *newimage = image;
        return(TRUE);
}
/* -library_code_end */
