 /*
  * Khoros: $Id: lviff2fits.c,v 1.1 1991/05/10 15:43:29 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lviff2fits.c,v 1.1 1991/05/10 15:43:29 khoros Exp $";
#endif

 /*
  * $Log: lviff2fits.c,v $
 * Revision 1.1  1991/05/10  15:43:29  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lviff2fits.c
 >>>>
 >>>>      Program Name: viff2fits
 >>>>
 >>>> Date Last Updated: Sat Mar  2 14:40:37 1991 
 >>>>
 >>>>          Routines: lviff2fits - the library call for viff2fits
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
#include "file_formats/fits.h"
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lviff2fits - library call for viff2fits
*
* Purpose:
*    
*    Converts  VIFF file format to FITS image file format
*    
*    
* Input:
*    
*         struct xvimage *viff_image - input image to be converted
*    
*    
* Output:
*    
*         struct fits **fits_image - resulting fits image.
*    
*    
*
* Written By: Robin Corbet, PSU
*    
*    7-Dec-90 Scott Wilson - Minor mods, doc fixes, cleanup, pane
*    cleaning
*    
*    
****************************************************************/


/* -library_def */
int lviff2fits(viff_image, fits_image)

struct  xvimage *viff_image;
struct  fits **fits_image;
/* -library_def_end */

/* -library_code */
{
    struct fits *new_fits_image;

    char *program = "lviff2fits";
    char *fits_ptr, *img_ptr, *fits_data;
   
    int nr, nc, bands, fits_data_size;
    int i,j,k;
    long unsigned data_type;
    int bytepix;
    double records;

    nr = viff_image->col_size;
    nc = viff_image->row_size;
    bands = viff_image->num_data_bands;
    data_type = viff_image->data_storage_type;

        switch (data_type) {
        case VFF_TYP_4_BYTE:
                bytepix = 4;
                break;
        case VFF_TYP_2_BYTE:
                bytepix = 2;
                break;
        case VFF_TYP_1_BYTE:
                bytepix = 1;
                break;
        default:
                fprintf(stderr, "viff2fits: VIFF data type unsupported\n");
                return (0);
                break;
        }

        /* check the input viff image to make sure it is in
         * a format that can be converted.
         * Must have 1 IMAGE in the file, must be of data storage
         * type BYTE and must have a map enable of OPTIONAL.
        */

/*    if (!propertype (program, viff_image, VFF_TYP_1_BYTE, FALSE)) {
        (void) fprintf (stderr,
        "%s: ERROR Input image must be of data type BYTE\n",program);
         return (0);
    }  */

    if (! (proper_num_images(program,viff_image,1,FALSE))) {
         (void) fprintf(stderr,
                 "%s: ERROR All inputs must contain only one image\n"
                 , program);
          return(0);
    }

    if (! (proper_map_enable(program,viff_image,VFF_MAP_OPTIONAL,FALSE))) {
         (void) fprintf(stderr,
                "%s: ERROR input must have map enable type OPTIONAL\n"
                ,program);
         return(0);
    }

    /* malloc room for the fits image structure */

    if ((*fits_image = (struct fits *)malloc(sizeof(struct fits)))==NULL)
    {
       (void) fprintf(stderr,"%s: No space for image, malloc failed!\n");
       return(0);
    }

        
    /* Allocate space for new fits image data */

    fits_data_size = bands*nr*nc*bytepix*sizeof(char);
    fits_data = (char *)malloc((unsigned int) fits_data_size);
    if (fits_data == NULL) {
      (void) fprintf(stderr,"%s: insufficient memory available\n", program);
      return(0);
    }

    bzero(fits_data, fits_data_size);
    new_fits_image = *fits_image; 

    /* set the header fields */
    new_fits_image->naxis = 3;   /* number of axes */
    new_fits_image->naxis3 = bands;   /* number of bands */
    new_fits_image->naxis2 = viff_image->col_size; /* number rows */
    new_fits_image->naxis1 = viff_image->row_size; /* num columns */
    new_fits_image->bitpix = bytepix*8;     /* bits per pixel */

    if ( viff_image->comment != NULL)
      strncpy(new_fits_image->title, viff_image->comment, 80);

    fits_ptr = fits_data;
    img_ptr = viff_image->imagedata;

    for ( i = 0; i < nr*bytepix*bands; i++) {
      for ( j = 0; j < nc; j++) {
        *fits_ptr = img_ptr[ i*nc+j ];
        fits_ptr++;
      }
    }

    (*fits_image)->imagedata = fits_data;
    return(1);
}
/* -library_code_end */
