 /*
  * Khoros: $Id: dxcorr.h,v 1.2 1992/03/20 23:19:29 dkhoros Exp $
  */

 /*
  * $Log: dxcorr.h,v $
 * Revision 1.2  1992/03/20  23:19:29  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dxcorr.h
 >>>>            Author: Ramiro Jordan, Jeremy Worley
 >>>> Date Last Updated: Thu Mar  5 12:06:53 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _dxcorr_h_
#define _dxcorr_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    dxcorr Argument Structure
*
****************************************************************/

typedef struct _dxcorr  {

/*
 *  input first file (xviff file) (Required infile)
 */
char	*i1_file;	/* input first file (xviff file) FILENAME */
int	 i1_flag;	/* input first file (xviff file) FLAG */

/*
 *  input second file (xviff file) (Required infile)
 */
char	*i2_file;	/* input second file (xviff file) FILENAME */
int	 i2_flag;	/* input second file (xviff file) FLAG */

/*
 *  resulting output file (xviff file) (Required outfile)
 */
char	*o_file;	/* resulting output file (xviff file) FILENAME */
int	 o_flag;	/* resulting output file (xviff file) FLAG */

/*
 *  number of points for cross-correlation sequence (Optional integer)
 */
int	 s_int; 	/* number of points for cross-correlation sequence INT */
int	 s_flag;	/* number of points for cross-correlation sequence FLAG */

/*
 *  define arithmetic on data (Optional logical)
 */
int	 j_logic;	/* define arithmetic on data LOGIC */
int	 j_flag;  	/* define arithmetic on data FLAG */

/*
 *  data processing direction (0 = down vectors, 1 = across bands) (Optional logical)
 */
int	 d_logic;	/* data processing direction (0 = down vectors, 1 = across bands) LOGIC */
int	 d_flag;  	/* data processing direction (0 = down vectors, 1 = across bands) FLAG */

/*
 * type of cross-correlation file to be created (Optional integer toggle - )
 */
int	 g_toggle;		/* type of cross-correlation file to be created INT TOGGLE */
int	 g_flag;		/* type of cross-correlation file to be created FLAG */

}  dxcorr_struct;

dxcorr_struct *dxcorr;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */

#define READIMAGE(image1,image2) \
image1 = readimage(dxcorr->i1_file);  \
if (image1 == NULL) {  \
   (void) fprintf(stderr, "dxcorr: Cannot read input image1 \n");  \
   exit(1);  /* Quit if bad image */ \
} \
image2 = readimage(dxcorr->i2_file);  \
if (image2 == NULL) {  \
   (void) fprintf(stderr, "dxcorr: Can not read input image2 \n");  \
   exit(1);  /* Quit if bad image */ \
}

#define CHECKTYPE(program, image1, image2) \
    if( ! (propertype(program,image1,VFF_TYP_FLOAT,FALSE)) && \
        ! (propertype(program,image1,VFF_TYP_COMPLEX,FALSE)) ) { \
          (void) fprintf(stderr,"%s: data storage type must be float or complex.",program); \
          exit(1); \
    }\
    if( ! (propertype(program,image2,VFF_TYP_FLOAT,FALSE)) && \
        ! (propertype(program,image2,VFF_TYP_COMPLEX,FALSE)) ) { \
          (void) fprintf(stderr,"%s: data storage type must be float or complex.\n\n",program); \
          exit(1); \
    } \
    if( propertype(program,image1,VFF_TYP_FLOAT,FALSE) != \
        propertype(program,image2,VFF_TYP_FLOAT,FALSE) ) { \
          (void) fprintf(stderr,"%s: both input files must be of same data type.  \n\n",program); \
          exit(1); \
    } \
    if( propertype(program,image1,VFF_TYP_COMPLEX,FALSE) != \
        propertype(program,image2,VFF_TYP_COMPLEX,FALSE) ) { \
          (void) fprintf(stderr,"%s: both input files must be of same data type.  \n\n",program); \
          exit(1); \
    }

#define CHECKINPUT(program, image1, image2) \
    proper_num_images(program,image1,1,TRUE);  \
    proper_map_enable(program,image1,VFF_MAP_OPTIONAL,TRUE); \
    proper_num_images(program,image2,1,TRUE);  \
    proper_map_enable(program,image2,VFF_MAP_OPTIONAL,TRUE)
/* -include_macros_end */

#endif
