 /*
  * Khoros: $Id: dfilconv.c,v 1.2 1992/03/20 23:31:28 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dfilconv.c,v 1.2 1992/03/20 23:31:28 dkhoros Exp $";
#endif

 /*
  * $Log: dfilconv.c,v $
 * Revision 1.2  1992/03/20  23:31:28  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dfilconv.c
 >>>>
 >>>>      Program Name: dfilconv
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	1D Filter Coefficient Conversion
 >>>>	
 >>>>	

 >>>>            Author: Ramiro Jordan
 >>>>
 >>>> Date Last Updated: Tue Feb 25 00:01:29 1992
 >>>>
 >>>>          Routines: main- the main program for dfilconv
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dfilconv.h"


/****************************************************************
 *
 * Routine Name:  main program for dfilconv
 *
 *       Input:  
 *          -i  input file (xviff file) 
 *          -o  resulting output file (xviff file) 
 *
 *
 *          [-j] scalar processing (0) or vector processing (1) (default)
 *          [-d] down vectors(0) or across bands(1) (default)
 *          [-t] type of conversion to be performed
 *		0 (choose lattice to transversal filter conversion (default)),
 *		or 1 (choose transversal to lattice filter conversion)
 *		   [default = 0] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *readimage();
int     out_option, arith_type, procdir;

/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);
READIMAGE(image);
CHECKTYPE(program,image);
CHECKTYPE(program,image);

arith_type = dfilconv->j_logic;
out_option = dfilconv->t_toggle;
procdir = dfilconv->d_logic;

/* -main_before_lib_call_end */

/* -main_library_call */

if(! ldfilconv ( image, out_option, arith_type, procdir ) )
        {
            (void) fprintf(stderr, "ldfilconv Failed\n");
            exit(1);
        }

/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(dfilconv->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dfilconv 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dfilconv :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t1D Filter Coefficient Conversion\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
(void) fprintf(stderr,"where \"t\" Conversion type to be performed:\n");
(void) fprintf(stderr,"\t\"t=0\" Lattice to Transversal coeff. conversion (default)\n");
(void) fprintf(stderr,"\t\"t=1\" Transversal to Lattice coeff. conversion \n");
(void) fprintf(stderr,"where \"j\" type of arithmetic to be used:\n");
(void) fprintf(stderr,"\t\"j=0\" scalar arithmetic \n");
(void) fprintf(stderr,"\t\"j=1\" complex arithmetic (default) \n\n");
(void) fprintf(stderr,"where \"d\" direction of processing:\n");
(void) fprintf(stderr,"\t\"d=0\" down vectors \n");
(void) fprintf(stderr,"\t\"d=1\" across bands (default)\n\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input file (xviff file)  (infile)\n");
	fprintf(stderr,"\t-o  resulting output file (xviff file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-j]  scalar processing (0) or vector processing (1) (default) (boolean) [true]\n");
	fprintf(stderr,"\t[-d]  down vectors(0) or across bands(1) (default) (boolean) [true]\n");
	fprintf(stderr, "\t[-t]  type of conversion to be performed\n");
	fprintf(stderr, "\t\t0  (choose lattice to transversal filter conversion (default)),\n");
	fprintf(stderr, "\t\tor 1  (choose transversal to lattice filter conversion)\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dfilconv\n");
	fprintf(stderr, "\t[-U] Gives the usage for dfilconv\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dfilconv.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dfilconv.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dfilconv
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input file (xviff file) \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output file (xviff file) \n        {outfile}: "; 
char	*j_pstr = 
	"\nEnter: (j) scalar processing (0) or vector processing (1) (default) \n        {boolean, (y/n)  [yes] }: "; 
char	*d_pstr = 
	"\nEnter: (d) down vectors(0) or across bands(1) (default) \n        {boolean, (y/n)  [yes] }: "; 
char	*t_pstr = "\nEnter: (t) type of conversion to be performed -- \n      \t\t0 (choose lattice to transversal filter conversion (default))\n\t\tor 1 (choose transversal to lattice filter conversion)\n  [0]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dfilconv", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dfilconv.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dfilconv: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dfilconv.ans");
		}

	     }

	}

	/*
	 * allocate the dfilconv structure
	 */
	dfilconv = (dfilconv_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dfilconv_struct));

	/*
	 * get required arguments for dfilconv
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dfilconv->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(dfilconv->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dfilconv->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    dfilconv->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(dfilconv->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(dfilconv->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dfilconv->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dfilconv->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dfilconv->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dfilconv->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dfilconv
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dfilconv->j_flag = vget_logic(fid, prompt_flag,
	"-j", j_pstr, &(dfilconv->j_logic), 1);

	dfilconv->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dfilconv->d_logic), 1);


	/*
	 * get optional toggles for dfilconv
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dfilconv->t_flag = vget_int(fid, prompt_flag,
		"-t", t_pstr, &(dfilconv->t_toggle),
		0, 0, 0);

		if ((dfilconv->t_toggle == 0 ) || 
		    (dfilconv->t_toggle == 1 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dfilconv->t_flag = vget_int(fid, prompt_flag,
		"-t", t_pstr, &(dfilconv->t_toggle),
		0, 0, 0);

		if ((dfilconv->t_toggle != 0 ) && 
		    (dfilconv->t_toggle != 1 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



