 /*
  * Khoros: $Id: pro_map_en.c,v 1.1 1991/05/10 15:40:47 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: pro_map_en.c,v 1.1 1991/05/10 15:40:47 khoros Exp $";
#endif

 /*
  * $Log: pro_map_en.c,v $
 * Revision 1.1  1991/05/10  15:40:47  khoros
 * Initial revision
 *
  */ 

/*
#
# FILE NAME:	pro_map_en.c
# 
# AUTHORS:	Tom Sauer, John Rasure
#               Modified from code done origianlly by Marcelo Teran
# 
# DATE:		2/6/89
# 
# DESCRIPTION:	Contains module proper_map_enable().
# 
# MODIFICATIONS:
#		John Rasure updated error messages.
#		Sat Jun  2 23:24:25 MDT 1990
# 
# ROUTINES:	proper_map_enable()
#		
*/

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */

#include "vinclude.h"	  


/**************************************************************
*
* MODULE NAME: 	proper_map_enable()
*
*     PURPOSE:	Check to see if a viff file or structure has the
*               proper map enable value.
*
*       INPUT:  prog 	- program name
*		*image	- viff data
*		type	- desired enable value
*		exit_flag
*
*      OUTPUT:  If exit_flag is true and match fails, an error 
*          	message is printed.
*      		If exit_flag is false and match fails, return(0).
*
*       USAGE:	If exit_flag is set, The routine will print out an
*		error message and then exit().  In this case, the
*		function should be declared (void).  If exit_flag
*               is not set (equal 0) then the function should be
*		declared int.
*
*
**************************************************************/
proper_map_enable(prog,image,type,exit_flag)
char  *prog;
struct xvimage *image;
unsigned long type;
int exit_flag;
{
   if(image->map_enable != type) {
      if (exit_flag == TRUE) {
         (void) fprintf(stderr, "\nError in program %s: \n",prog);
         switch(type){
            case VFF_MAP_OPTIONAL :
               (void) fprintf(stderr, 
"Map enable value should be to VFF_MAP_OPTIONAL.\n");
               (void) fprintf(stderr, 
"The viff data uses a map that is not optional, the map should be removed.\n");
               (void) fprintf(stderr, 
"One way to accomplish this is to use vmapdata(1).\n");
               (void) fprintf(stderr, 
"It is likely that the viff data has a map of VFF_MAP_FORCE because of a\n");
               (void) fprintf(stderr, 
"psuedo coloring or color compression operation.\n");
               exit(1);
               break;
            case VFF_MAP_FORCE :
               (void) fprintf(stderr, 
"Map enable value should be set to VFF_MAP_FORCE.\n");
               (void) fprintf(stderr, 
"A map type of FORCE indicates that the data should be mapped to have its\n");
               (void) fprintf(stderr, 
"correct value or interpretation.\n");
               exit(1);
               break;
            default :
               (void) fprintf(stderr, "Map enable value is unknown.\n");
               exit(1);
               break;
	 }
      }
      else return(0);
   }
return(1);
}
