#include <stdio.h>
#include <math.h>
#include <malloc.h>

/* Possibilities for global variable 'target' */
#define FLOAT_NOT_INT 0		/* Set with -float option */
#define FLOAT_AND_INT 1		/* Set with -all option */
#define INT_NOT_FLOAT 2		/* Set with -int option */

/* Possibilities for global variable 'type' */
#define BINARY 0
#define ASCII 1

#define FMAX 15		/* Size of global F array.  */

struct LINE {		/* This is used to store characters between targets. */
	char c[1200];
};

char fformat[10];   /* Floating point output format */
char infilename[80], outfilename[80];
char outfileroot[80];	/* If animation, outfilenames have this root */
char suffix[80];	/* If animation, outfilenames have this suffix */
char tag[10];		/* Tag on target values */
FILE *infile, *outfile;
int type;	/* ASCII or BINARY? */
int target;	/* Do we want to target INT_NOT_FLOAT, etc */
int skip;	/* Skip this many lines / bytes at top of infile */
long tail;	/* Skip from this line # / byte # to end. */
		/* (Skip above implies copy over without processing. */
int chunk;	/* Size of array passed to function (x[], y[], etc.) */
int frames, frame;	/* Animation?  Which frame are we on?  */
int debug;	/* Print lots of variables as program proceeds */
double F[FMAX];		/* Global float variables for use in functions */
double dF[FMAX];	/* Direction in which F should vary over course
			    of animation. */
double oF[FMAX];	/* In case of animation, original F's stored here,
			    while the F array varies with each frame.  */
double A,B,C,D,E;	/* More easily-accessed global floats. */
long J,K,L,M,N;		/* Easily-accessed global ints */
