
/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota 
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 *  Written by Steve Anderson and Toby Orloff, summer 1990.
 */

#define INCLUDE_DIR "/usr/local/include"
#define O_DIR "/usr/local/lib"

#include <stdio.h>
#include <string.h>

char infile[20], outfile[20];
char option[20][40];
int glob_present, int_present, float_present, usage_present, init_present;

main (argc,argv)
int argc;
char **argv;
{
  int i;
  char command[600], obj[500];

  Initialize_globals ();
  Parse_args (argc,argv);
  Check_presence (argv);
  sprintf (command, "cc -c -g -I%s %s", INCLUDE_DIR, infile);
  execute (command);
  infile[strlen(infile)-1] = 'o';
  sprintf (obj, "%s/parse.o %s/main.o %s/attack.o %s/target.o %s", O_DIR, O_DIR, O_DIR, O_DIR, infile);
  if (!float_present) {
    sprintf (obj, "%s %s/float_fnct.o", obj, O_DIR);
    if (!int_present)   sprintf (obj, "%s %s/int_fnct.o", obj, O_DIR);
  } else if (!int_present) sprintf (obj, "%s %s/int_pass.o", obj, O_DIR);
  if (!usage_present) sprintf (obj, "%s %s/usage.o", obj, O_DIR);
  if (!init_present) sprintf (obj, "%s %s/glob_init.o", obj, O_DIR);
  if (!glob_present) sprintf (obj, "%s %s/glob_fnct.o", obj, O_DIR);
  sprintf (command, "cc -g %s -lm", obj);
  for (i=0; i<20; i++) sprintf (command, "%s %s", command, option[i]);
  execute (command);
}

Initialize_globals ()
{
  int i;

  int_present = 0;
  float_present = 0;
  usage_present = 0;
  init_present = 0;
  glob_present = 0;
  for (i=0; i<20; i++) sprintf (option[i], "");
}

Parse_args (argc,argv)
int argc;
char **argv;
{
  int i;
  int output_set = 0;

  if (argc < 2) {
    fprintf (stderr, "Usage: %s <filename.c> [compiler options]\n",argv[0]);
    fprintf (stderr, "(Note that filename.c must be the first argument!)\n");
    exit (1);
  }
  if (strcmp (argv[1]+strlen(argv[1])-2,".c")) {
    fprintf (stderr, "%s: function file name must end in .c\n",argv[0]);
    exit (1);
  }
  sprintf (infile, argv[1]);
  for (i=2; i<argc; i++) {
    sprintf (option[i-2], argv[i]);
    if (strcmp(option[i-2], "-o") == 0) output_set = 1;
  }
  if (output_set == 0) {
    sprintf (option[argc-2], "-o");
    sprintf (option[argc-1], infile);
    sprintf (option[argc-1]+strlen(infile)-2, "");
  }
}

execute (command)
char *command;
{
  fprintf (stderr, "%s\n",command);
  system (command);
}

Check_presence (argv)
char **argv;
{
  FILE *fp;
  char line[25];
  int include_present = 0;

  if ((fp = fopen (infile, "r")) == NULL) {
    fprintf (stderr, "%s: Cannot open input file %s for examination.  Stop.\n", argv[0], infile);
    exit (1);
  }
  while ((fgets (line, 24, fp)) != NULL) {
    if (strncmp (line, "#include <omni_proc.h>\n", 24) == 0) {
      include_present = 1;
    }
    if (strncmp (line, "integer_function", 16) == 0) {
      int_present = 1;
    }
    if (strncmp (line, "float_function", 14) == 0) {
      float_present = 1;
    }
    if (strncmp (line, "Usage", 5) == 0) {
      usage_present = 1;
    }
    if (strncmp (line, "global_init", 11) == 0) {
      init_present = 1;
    }
    if (strncmp (line, "global_function", 15) == 0) {
      glob_present = 1;
    }
  }
  fclose (fp);
  if (!include_present) {
    fprintf (stderr, "%s: Error.  Input file %s did not ", argv[0], infile);
    fprintf (stderr, "contain:\n#include <omni_proc.h>\n");
    exit (1);
  }
}
