#include <omni_proc.h>

global_init ()
{
  chunk = 3;
  frames = 10;
  sprintf (suffix, ".bez");
}

global_function ()
{
  if (chunk < 3) {
    fprintf (stderr, "Chunk should be set >= 3.\n");
    exit (1);
  }
  if (!frames) {
    fprintf (stderr, "This program requires the -animate option.\n");
    exit (1);
  }
}

float_function (in, out, pos)
double *in, *out;
int pos;
{
  double disp[3];
  double time;
  int i;

  time = ((double)frame)/((double)frames - 1.)*F[4];
  for (i=0; i<3; i++) {
    disp[i] = F[i]*time;
  }
  disp[2] += F[3] * time * time / 2.;
  for (i=0; i<3; i++) out[i] = in[i] + disp[i] + F[i+5];
  for (i=3; i<chunk; i++) out[i] = in[i];
}

Usage ()
{
  fprintf (stderr, "\nGravity is given a shape, an initial velocity vector,");
  fprintf (stderr, " a gravity factor,\nand a total time.  It requires the ");
  fprintf (stderr, "animation option to be engaged, and -chunk 3 to be\n");
  fprintf (stderr, "included on the command line.  [F0, F1, F2] is the ");
  fprintf (stderr, "initial velocity,\nand F3 is the z-direction acceler");
  fprintf (stderr, "ation.  (Remember to make this negative for regular\n");
  fprintf (stderr, "gravity.)  F4 is the total number of seconds occupied ");
  fprintf (stderr, "all the frames.\n");
}
