./" $Id: heisenberg.nr,v 4.0 89/06/06 15:38:46 mbp Exp $
./"
./" heisenberg.nr: nroff source for help file
./"
./" ***************************************************************************
./" *                          Copyright (C) 1990 by                          *
./" *        Mark B. Phillips, William M. Goldman, and Robert R. Miner        *
./" *                                                                         *
./" *  Permission to use, copy, modify, and distribute this software, its     *
./" *  documentation, and any images it generates for any purpose and without *
./" *  fee is hereby granted, provided that                                   *
./" *                                                                         *
./" *  (1) the above copyright notice appear in all copies and that both that *
./" *      copyright notice and this permission notice appear in supporting   *
./" *      documentation, and that the names of Mark B.  Phillips, William M. *
./" *      Goldman, Robert R.  Miner, or the University of Maryland not be    *
./" *      used in advertising or publicity pertaining to distribution of the *
./" *      software without specific, written prior permission.               *
./" *                                                                         *
./" *  (2) Explicit written credit be given to the authors Mark B. Phillips,  *
./" *      William M. Goldman, and Robert R. Miner in any publication which   *
./" *      uses part or all of any image produced by this software.           *
./" *                                                                         *
./" * This software is provided "as is" without express or implied warranty.  *
./" ***************************************************************************
./"
.ll 7.1in
.in +3
.sp1
.ce
Heisenberg Graphics
.sp1
The Heisenberg Graphics frame consists of of several subwindows:
.sp
.nf
   +---------------------------------------------------------+
   |                                          |   control    |
   |               message panel              |              |
   |                                          |    panel     |
   |---------------------------------------------------------|
   |                                          |              |
   |                                          |              |
   |                                          |              |
   |                graphics                  |    view      |
   |                 canvas                   |   control    |
   |                                          |    panel     |
   |                                          |              |
   |                                          |              |
   |                                          |              |
   |                                          |              |
   |---------------------------------------------------------|
   |                  error message panel                    |
   +---------------------------------------------------------+
.fi
.sp1
GRAPHICS CANVAS
.in +3
The graphics output appears here. 
.in -3
.sp
MESSAGE PANEL
.in +3
The program displays messages and prompts here.
.in -3
.sp
CONTROL PANEL
.in +3
This panel contains buttons which control general aspects of the
program.  To find out a button's name, point at it with the mouse
cursor and hold the right mouse button down; this causes a one-line
menu to appear which tells the name of the button.  The buttons are:
.in +6
.sp
.ti -3
"Help" button: Causes this help window to be displayed.
.sp
.ti -3
"Printer" button: Causes another frame to be displayed which you can
use to generate PostScript files.  See POSTSCRIPT FRAME below for
details.
.sp
.ti -3
"Exit" button: terminates the program, after confirmation.
.in -6
.in -3
.sp
VIEW CONTROL PANEL
.in +3
This panel contains various gadgets which you use modify the display
of the graphics.  To find out a button's name, point at it with the
mouse cursor and hold the right mouse button down; this causes a
one-line menu to appear which tells the name of the button.
.sp
The viewing transformation which Heisenberg uses to project
3-dimensional graphics onto the graphics canvas is analogous to a
camera taking a picture of an object in space.  The setup is defined
by the position of the camera (the "eye" point), a point in space
towards which the camera is pointed (the "focus" point), and an amount
of twisting of the camera about its line of sight (determined by an
"up" direction).  The view control buttons change this setup in the
ways described below.  Clicking the left mouse button on one of these
buttons will cause Heisenberg to change the viewing transformation in
the prescribed manner and then redraw the current picture using the
new transformation.  To make the change go in the opposite direction
(e.g.  right instead of left, in instead of out, etc), hold the shift
key on the keyboard down while clicking the left mouse button.
.in +6
.sp
.ti -3
"Horizontal Sweep" button: rotates the camera horizontally about the
focus point, keeping the same up direction.  The amount of rotation is
given by the value of the "Rotation Angle" slider.
.sp
.ti -3
"Vertical Sweep" button: rotates the camera vertically about the focus
point.  The up direction rotates too.  The amount of rotation is given
by the value of the "Rotation Angle" slider.
.sp
.ti -3
"Tilt" button: rotates the camera about its line of sight; the eye and
focus points do not move.  The amount of rotation is given by the
value of the "Rotation Angle" slider.
.sp
.ti -3
"Horizontal Pan" button: rotates the focus point horizontally about
the camera, keeping the same up direction.  The amount of rotation is
one tenth of the value given by the value of the "Rotation Angle"
slider.
.sp
.ti -3
"Vertical Pan" button: rotates the focus point vertically about the
camera.  The up direction rotates too.  The amount of rotation is one
tenth of the value given by the value of the "Rotation Angle" slider.
.sp
.ti -3
"Perspective" button: changes the degree of 3D perspective by moving
the camera towards or away from the focus point.  The distance between
the eye and focus points is multiplied or divided by the value of the
"Perspective Factor" slider.
.sp
.ti -3
"Zoom" button: scales the picture to make it larger or smaller; the
scale is multiplied or divided by the value of the "Zoom Factor"
slider.  The eye, focus, and up values are not changed.
.sp
.ti -3
"Redraw" button: causes the picture to be redrawn without changing the
viewing transformation.
.sp
.ti -3
"Reset" button: resets the transformation to a standard default
setting in which everything is centered on the canvas.  This is useful
if you have "gotten lost".
.sp
.ti -3
"Viewing Transformation" button: causes the "Viewing Transformation"
frame to appear.  See VIEWING TRANSFORMATION FRAME below for details.
.sp
.ti -3
"Animation" button: causes the "Animation" frame to appear.  See
ANIMATION FRAME below for details.
.sp
.ti -3
"Rotation Angle" sider: determines the number of degrees of rotation
effected by each click of one of the rotation buttons. (NOTE: the
"Pan" buttons rotate by one-tenth this amount.)
.sp
.ti -3
"Zoom Factor" slider: determines the amount by which the scaling is
changed when the "Zoom" button is pressed.
.sp
.ti -3
"Perspective Factor" slider: determines the amount by which the
perspective is changed when the "Perspective" button is pressed.  The
distance between the eye and focus.
.sp
.ti -3
"Drawing Mode" cycle: sets the current drawing mode.  There are two
modes: "Continuous", and "Batch".  In continuous mode, each vector is
displayed in the canvas as it is drawn.  In batch mode, all vectors
are drawn in memory and then the canvas is refreshed instantly from
this image.  Batch mode is faster and is gives smoother blending when
changing views rapidly.
.in -6
.in -3
.sp
ERROR PANEL
.in +3
This is the thin stip across the bottom of the frame.  Heisenberg
displays various error messages here.
.in -3
.sp
POSTSCRIPT FRAME
.in +3
This frame appears when appears when you press the "Printer" button in
the control panel.  You can use it to create and/or print a PostScript
image of the contents of the graphics canvas.  This frame has the
following gadgets in it:
.in +6
.sp
.ti -3
"Printer" button: sends a PostScript image of the graphics canvas to
the printer.
.sp
.ti -3
"File" button: writes a PostScript image of the graphics canvas to a
file.
.sp
.ti -3
"Filename" field: the name of the file to write to when the "File"
button is pressed.
.sp
.ti -3
"Label" field: a text label which will be printed under the picture
.sp
.ti -3
"Time on Picture" cycle: says whether or not to print the current date
and time at the bottom of the picture
.sp
.ti -3
"Done" button: causes the PostScript frame to disappear.
.in -6
.in -3
.sp
VIEWING TRANSFORMATION FRAME
.in +3
This frame appears when you press the "Viewing Transformation" button
in the view control panel.  You can use to it explicity see and change
the values of the parameters which specify the viewing transformation.
The frame has several text fields which display the eye, focus, up,
and view plane window data.  To change one of these, point to it with
the mouse cursor, click the left mouse button so that the triangular
carat moves to the field you want to change, use the keyboard to
change the value, and then press the "Redraw" button (either the one
in the "Viewing Transformation" frame or the one in the view control
panel).  Heisenberg will redraw the picture using the new data.  The
"Done" button causes the frame to disappear.
.in -3
.sp
ANIMATION FRAME
.in +3
This frame appears when you press the "Animation" button in the view
control panel.  You can use it to save a sequence of bitmap images and
play them back in rapid succession.  Just how rapid this is depends on
the machine you are using.  On a Sun 3/50, it is sometimes not much
faster than redrawing.  On a 3/280 with an FPA, it looks like
real-time animation.  The gadgets in the "Animation" frame and their
functions are:
.in +6
.sp
.ti -3
"Save Frame" button: saves a single image of the graphics canvas in
memory.  Up to 30 images can be saved.
.sp
.ti -3
"Frames Saved" message: tells how many frames you have saved.
.sp
.ti -3
"Frames Available" message: tells how many  more frames you can
save.
.sp
.ti -3
"Clear Saved Frames" button: erases all saved frames from memory.
.sp
.ti -3
"Save Sequence of Frames" button: saves a sequence of frames.  The
number of frames in the sequence is given by the value of the
"Recording Count" slider.  After pressing the "Save Sequence of
Frames" button, you specify how you want the viewing transformation to
change between the frames of the sequence by pressing one of the view
control buttons in the view control panel (possibly with the shift key
held down).  Heisenberg then saves a sequence of "Recording Count"
frames, with the equivalent of one press of that view control button
between each frame.  If you decide not to record a sequence after you
have pressed the "Save Sequence of Frames" button, just press the
button again to cancel.  If you want to interrupt a recording sequence
after it has started, press the "Stop" key (L1) in the upper left
corner of the keyboard.
.sp
.ti -3
"Recording Count" slider: specifies the number of frames to save when
the "Save Sequence of Frames" button is pressed.  This must be less
than or equal to the number of available frames.
.sp
.ti -3
"Play Back Saved Frames" button: causes the saved frames to be played
back in the order in which they were saved, starting with the first
one saved.  The sequence is repeated a number of times specified by
the value of the "Playback Count" slider.  The amount of time to wait
between each frame is given by the "Interframe Delay" slider.  To
interrupt a playback sequence before it has finished, press the "Stop"
key (L1) in the upper left corner of the keyboard.
.sp
.ti -3
"Playback Count" slider: specifies the number of times to play back
the saved sequence of frames when the "Play Back Saved Frames" button
is pressed.
.sp
.ti -3
"Interframe Delay" slider: specifies a delay, in milliseconds, between
each frame when a sequence is being played back.  Unless you are using
a really fast machine or you want a really slow movie, this should be
zero.
.in -6
.in -3
