/* $Id: datatypes.h,v 4.0 89/06/06 15:38:38 mbp Exp $
 *
 * datatypes.h: global typedefs
 */

/***************************************************************************
 *                          Copyright (C) 1990 by                          *
 *        Mark B. Phillips, William M. Goldman, and Robert R. Miner        *
 *                                                                         *
 *  Permission to use, copy, modify, and distribute this software, its     *
 *  documentation, and any images it generates for any purpose and without *
 *  fee is hereby granted, provided that                                   *
 *                                                                         *
 *  (1) the above copyright notice appear in all copies and that both that *
 *      copyright notice and this permission notice appear in supporting   *
 *      documentation, and that the names of Mark B.  Phillips, William M. *
 *      Goldman, Robert R.  Miner, or the University of Maryland not be    *
 *      used in advertising or publicity pertaining to distribution of the *
 *      software without specific, written prior permission.               *
 *                                                                         *
 *  (2) Explicit written credit be given to the authors Mark B. Phillips,  *
 *      William M. Goldman, and Robert R. Miner in any publication which   *
 *      uses part or all of any image produced by this software.           *
 *                                                                         *
 * This software is provided "as is" without express or implied warranty.  *
 ***************************************************************************/


typedef Complex Cvector[3];
typedef Complex C2vector[2];
typedef Complex Cmatrix[3][3];

typedef struct Hpoint_s {	/* Hpoint = a point in Heisenberg space; */
	Complex hor;
	double ver;
} Hpoint;

typedef struct Chain_s {	/* Chains are represented by their */
	Hpoint cen;		/* center and */
	double rad;		/* radius */
} Chain;

typedef struct Rcircle_s {	/* R-circles are represented by their */
	Hpoint cen;		/* center and */
	Complex c_rad;		/* complex radius */
	char finite;		/* finite flag */
} Rcircle;

typedef struct Spinal_s {	/* Spinal is represented by its */
	Hpoint p1,p2;		/* vertices */
} Spinal;

typedef struct Reflection_s {
  Chain c;
  Complex f;
} Reflection;

typedef struct Transformation_s {
  int			op;
  union {
    Hpoint     p;
    Complex    f;
    Rcircle   rc;
    Reflection r;
  }			data;
} Transformation;
