/***************************************************************************
 *                Copyright (C) 1990 by Mark B. Phillips                   *
 *                                                                         *
 *  Permission to use, copy, modify, and distribute this software, its     *
 *  documentation, and any images it generates for any purpose and without *
 *  fee is hereby granted, provided that                                   *
 *                                                                         *
 *  (1) the above copyright notice appear in all copies and that both      *
 *      that copyright notice and this permission notice appear in         *
 *      supporting documentation, and that the names of Mark B.            *
 *      Phillips, or the University of Maryland not be used in             *
 *      advertising or publicity pertaining to distribution of the         *
 *      software without specific, written prior permission.               *
 *                                                                         *
 *  (2) Explicit written credit be given to the author Mark B. Phillips    *
 *      in any publication which uses part or all of any image produced    *
 *      by this software.                                                  *
 *                                                                         *
 * This software is provided "as is" without express or implied warranty.  *
 ***************************************************************************/

#ifndef GLGTEXTDEF

#define GlgCTRL_U	'\025'
#define GlgDEL		'\177'
#define GlgCTRL_J	'\012'
#define GlgRET		'\015'

typedef struct {

  /* pointer to place to store text value */
  char *string;

  /* declared length (# chars) of string */
  int maxlen;

  /* callback procedure */
  int (*proc)();

  /* lower left corner of text gadget */
  double x, y;

  /* Background, text, and outline colors */
  Colorindex bgnd, txtcol, outline;

} GlgText;

extern int GlgTextDraw();
extern int GlgTextEvent();

/*-----------------------------------------------------------------------
 * MACRO:	TEXT
 * Description:	define a text gadget
 * Args:	text: name for GlgText object
 *		gadget: name for corresponding GlGadget object
 *		string: pointer to place to store text string
 *		n: declared length (# chars) of string
 *		x,y: location of lower left corner of text
 *		bgnd: background color
 *		txtcol: text color
 *		outline: outline color
 * Author:	mbp
 * Date:	Mon Jun  4 13:22:19 1990
 */
#define GLGTEXT(text, gadget, string, n, proc, x, y, bgnd, txtcol, outline) \
  GlgText text =						\
   { string, n, proc, x, y, bgnd, txtcol, outline };		\
  GlGadget gadget =						\
   { (char*)(&text), GlgTextDraw, GlgTextEvent }

#define GLGTEXTDEF

#endif
