#! /bin/csh -f

# $Id$
#TPL
#TPL	DO NOT CHANGE ANY LINE IN THIS FILE THAT BEGINS WITH '#TPL'
#TPL	
#TPL	This file is a template to be used in creating the actual
#TPL	shell script.  The makefile creates the file 'Heisenberg' from
#TPL	this one by replacing the following strings in this file with
#TPL	actual values:
#TPL
#TPL		HEISENBERGPATH
#TPL		ELBOWDPATH
#TPL		HEISMATHPATH

#TPLWARNING

# Shell script to run Heisenberg.

# usage: Heisenberg [-port <n>] [graphicshost]

# This script handles all the startup steps automatically, BUT ONLY
# WORKS IF THE MATHEMATICA HOST CAN 'rsh' TO THE GRAPHICS HOST WITHOUT
# HAVING TO SPECIFY A PASSWORD.
#
# This script
# 	(1) starts the elbow daemon on the graphics host via rsh
# 	(2) runs the HeisMath shell script to start Mathematica

set portargs = ""

if ($#argv > 0) then
  if ( "$1" == "-port" ) then
    shift
    if ($#argv <= 0) goto usage
    set portargs = "-port $1"
    setenv ELBOWPORT $1
    shift
  endif
endif

if ($#argv > 0) then
  set graphicshost = $1
  shift
else
  if $?ELBOWSERVER then
    set graphicshost = $ELBOWSERVER
  else
    echo "Enter name of Heisenberg graphics host"
    echo -n "  (hit <Return> to use '""`hostname`""'): "
    set graphicshost = $<
    if ( "$graphicshost" == "" ) then
      set graphicshost = "`hostname`"
    endif
  endif
endif

if ($argv > 0) then
  goto usage
endif

set heisenberg = HEISENBERGPATH
set elbowd = ELBOWDPATH
set HeisMath = HEISMATHPATH

set thisdir = "`pwd`"

rsh $graphicshost "setenv WINDOW_PARENT /dev/win0 ; setenv WMGR_ENV_PLACEHOLDER /dev/win1 ; cd $thisdir ; $elbowd $portargs $heisenberg" -p &

exec $HeisMath $graphicshost

echo 'Heisenberg: exec failed.'
exit -1

usage:
	echo 'usage: Heisenberg [-port <n>] [graphicshost]'
	exit -1
