#! /bin/csh -f

# $Id$
#TPL
#TPL	DO NOT CHANGE ANY LINE IN THIS FILE THAT BEGINS WITH '#TPL'
#TPL	
#TPL	This file is a template to be used in creating the actual
#TPL	shell script.  The makefile creates the file 'HeisMath' from
#TPL	this one by replacing the following strings in this file with
#TPL	actual values:
#TPL
#TPL		HEISPACKAGEPATH
#TPL		MATHDIR
#TPL		MACHDIR

#TPLWARNING

# Shell script to start Mathematica and initialize Heisenberg; assumes
#   that the graphics daemon is already running on the graphics host.

# usage: HeisMath [-port <n>] [graphicshost]

# This script:
# 	(1) starts Mathematica on the current host
# 	(2) reads in Heisenberg.m
# 	(3) executes gConnect[]

if ($#argv > 0) then
  if ( "$1" == "-port" ) then
    shift
    if ($#argv <= 0) goto usage
    setenv ELBOWPORT $1
    shift
  endif
endif

if ($#argv > 0) then
  set graphicshost = $1
  shift
else
  if $?ELBOWSERVER then
    set graphicshost = $ELBOWSERVER
  else
    echo -n "Enter name of Heisenberg graphics host: "
    set graphicshost = $<
    if ( "$graphicshost" == "" ) then
      echo "Null host.  HeisMath aborted."
      exit -1
    endif
  endif
endif

if ($argv > 0) then
  goto usage
endif

set heisdir = HEISPACKAGEPATH
set mathdir = MATHDIR
set machdir = MACHDIR

if ( "$machdir" == "Bin.sun3" ) then
	set machdir = "$machdir.`$mathdir/Install/foption`"
endif
set path = ( $path $mathdir/$machdir/Display )

setenv ELBOWSERVER $graphicshost

exec $mathdir/$machdir/mathexe				\
	-pwpath '{"'$mathdir/Install'"}'		\
	-run '$Path = Join[				\
		$Path,					\
		{					\
			"~",				\
			"'$mathdir/Init'",		\
			"'$mathdir/Packages'",		\
			"'$heisdir'"			\
		}					\
	]' 						\
	-run '<<Heisenberg.m' 				\
	-run 'gConnect[]'				\
	"$*"

echo 'HeisMath: exec failed.'
exit -1

usage:
	echo 'usage: HeisMath [-port <n>] [graphicshost]'
	exit -1
