/* $Id: matrix.h,v 4.0 89/06/06 15:38:51 mbp Exp $
 *
 * matrix.h: header file for matrix.c
 *
 * By Michael J. Raue at the University of Maryland, Spring 1988.
 *
 * Minor modifications by Mark Phillips
 */

/************************************************************************
 *      Copyright (C) 1989 by Michael J. Raue, Mark B. Phillips         *
 *			and William M. Goldman                          *
 * 									*
 * Permission to use, copy, modify, and distribute this software and	*
 * its documentation for any purpose and without fee is hereby granted,	*
 * provided that the above copyright notice appear in all copies and	*
 * that both that copyright notice and this permission notice appear in	*
 * supporting documentation, and that the names of Michael J. Raue,	*
 * Mark B. Phillips, William M. Goldman, or the University of Maryland	*
 * not be used in advertising or publicity pertaining to distribution	*
 * of the software without specific, written prior permission.  This	*
 * software is provided "as is" without express or implied warranty.	*
 ************************************************************************/

/* To use this package, the user must do three things:

          1. #include this file in his application program.
          2. Access the math library at compile time with "-lm".
          3. Create a file called "matrixentry.h".  This file will contain
             the type definition of the required matrix entries, as well as
             defining certain basic operations.  Examples are contained in
             the files "matrixentry.real", "matrixentry.double", 
             "matrixentry.int", and "matrixentry.complex", which the user
             may use instead of creating a new file.


    Created by Michael J. Raue at the University of Maryland, Spring 1988.
*/


  
#define TRUE 1
#define FALSE 0

/* IND() does the indexing of an RxN matrix of arbitrary size, where 
   C is the # of columns.   
*/
#define IND(i, j, C)  ( (i) * (C) + (j) )
