


















































typedef struct Complex_s {
	double	re,im;		
	char	inf;		
	} Complex;



extern Complex C_ZERO, C_ONE, C_NEG_ONE, C_NEG_I, C_I, C_INFINITY;
extern char *c_error;

double c_enorm(), c_enorm_sq(), c_edist(), c_arg();









































typedef Complex Cvector[3];
typedef Complex C2vector[2];
typedef Complex Cmatrix[3][3];

typedef struct Hpoint_s {	
	Complex hor;
	double ver;
} Hpoint;

typedef struct Chain_s {	
	Hpoint cen;		
	double rad;		
} Chain;

typedef struct Rcircle_s {	
	Hpoint cen;		
	Complex c_rad;		
	char finite;		
} Rcircle;

typedef struct Spinal_s {	
	Hpoint p1,p2;		
} Spinal;

typedef struct Reflection_s {
  Chain c;
  Complex f;
} Reflection;

typedef struct Transformation_s {
  int			op;
  union {
    Hpoint     p;
    Complex    f;
    Rcircle   rc;
    Reflection r;
  }			data;
} Transformation;




extern int errno, signgam;



extern double fmod(), gamma();
extern int matherr();



extern double asinh(), acosh(), atanh();
extern double erf(), erfc();
extern double exp(), expm1(), log(), log10(), log1p(), pow();
extern double fabs(), floor(), ceil(), rint();
extern double lgamma();
extern double hypot(), cabs();
extern double copysign(), drem(), logb(), scalb();
extern int finite();
extern double j0(), j1(), jn(), y0(), y1(), yn();
extern double sin(), cos(), tan(), asin(), acos(), atan(), atan2();
extern double sinh(), cosh(), tanh();
extern double cbrt(), sqrt();
extern double modf(), ldexp(), frexp(), atof();


































struct exception {
	int type;
	char *name;
	double arg1;
	double arg2;
	double retval;
};














extern	struct	_iobuf {
	int	_cnt;
	unsigned char *_ptr;
	unsigned char *_base;
	int	_bufsiz;
	short	_flag;
	char	_file;		
} _iob[];




























extern struct _iobuf	*fopen();
extern struct _iobuf	*fdopen();
extern struct _iobuf	*freopen();
extern struct _iobuf	*popen();
extern struct _iobuf	*tmpfile();
extern long	ftell();
extern char	*fgets();
extern char	*gets();

extern char	*ctermid();
extern char	*cuserid();
extern char	*tempnam();
extern char	*tmpnam();










  






 















				







  
extern int chain_resolution;

  
extern int slice_count;

  
extern int rcircle_resolution;

  
extern double vert_chain_min;

  
extern double vert_chain_max;

  
extern int meridian_count;

  
extern double fudge;

  
extern int spinaldrawtype;

  




  
extern double wbox_low[];

  
extern double wbox_high[];

  
extern double maxlinelen;






char *segment_name();
char *type_string();
double ang_inv();
double chain_v_coord();
extern char *color_name();
extern int lgd_put_string();
extern int cmd_msg();
extern char *lgd_get_string();
extern char *cmd_get_string();
extern int parse_command();
extern double acosh();		












int op;
Spinal sp;

main(argc, argv)
     int argc;
     char *argv[];
{
  initialize();

  if (parse_args(argc, argv))
    switch (op) {
    case  6:
      mesh_spinal(&sp, (&_iob[1]));
      break;
    case  7:
      quad_spinal(&sp, (&_iob[1]));
      break;
    }
  else
    usage();

  exit(0);
}

parse_args(argc, argv)
     int argc;
     char *argv[];
{
  int params_done;
  double d[6],i;

  if (argc < 3) return(0);

  params_done = 0;
  while (!params_done) {
    --argc; ++argv;
    if (argc < 1) return(0);
    switch (fsa_parse(*argv)) {
    case 1:
      --argc; ++argv;
      if (argc < 1) return(0);
      chain_resolution = atoi(*argv);
      break;
    case  2:
      --argc; ++argv;
      if (argc < 1) return(0);
      slice_count = atoi(*argv);
      break;
    default:
      params_done = 1;
      break;
    }
  }

  --argc; ++argv;
  if (argc < 1) return(0);
  op = fsa_parse(*argv);
  if ((op !=  6) && (op !=  7)) return(0);

  for (i=0; i<6; ++i) {
    --argc; ++argv;
    if (argc < 1) return(0);
    d[i] = atof(*argv);
  }

  if (argc != 1) return(0);

  sp.p1.hor.re	= d[0];
  sp.p1.hor.im	= d[1];
  sp.p1.ver	= d[3];
  sp.p2.hor.re	= d[4];
  sp.p2.hor.im	= d[5];
  sp.p2.ver	= d[6];
}  

initialize()
{
  fsa_initialize( 0);
  fsa_install("cres",	1);
  fsa_install("ssc",	 2);
  fsa_install("ms",	 6);
  fsa_install("qs",	 7);
}

fatal(s)
     char s;
{
  fprintf("%s\n", s);
  exit(-1);
}

usage()
{


   fprintf((&_iob[2]),"%s\n","usage: hsurface [parameter options] {ms | qs} x1 y1 v1 x2 y2 v2 \
> outfile");
   fprintf((&_iob[2]),"%s\n","");
   fprintf((&_iob[2]),"%s\n","  parameter options:");
   fprintf((&_iob[2]),"%s\n","    cres n:");
   fprintf((&_iob[2]),"%s\n","      set chain resolution (longitudinal increment) to n (an integer \
> 1)");
   fprintf((&_iob[2]),"%s\n","    ssc n");
   fprintf((&_iob[2]),"%s\n","      set slice count (latitudinal increment) to n (an integer > 1)");
   fprintf((&_iob[2]),"%s\n","  ms:");
   fprintf((&_iob[2]),"%s\n","    generate a mesh for the spinal");
   fprintf((&_iob[2]),"%s\n","  qs:");
   fprintf((&_iob[2]),"%s\n","    generate a list of quadrilaterals for the spinal");
   fprintf((&_iob[2]),"%s\n","  x1 y1 v1:");
   fprintf((&_iob[2]),"%s\n","    Heisenberg coordinates of first vertex");
   fprintf((&_iob[2]),"%s\n","  x2 y2 v2:");
   fprintf((&_iob[2]),"%s\n","    Heisenberg coordinates of second vertex");
   fprintf((&_iob[2]),"%s\n","");


}

quad_spinal()
{}
