/* $Id: complex.h,v 4.0 89/06/06 15:38:32 mbp Exp $
 *
 * complex.h: header file for complex.c
 *  
 * (This is part of a general complex numbers arithmetic package,
 * which may be used separately from HEISENBERG.  The package consists
 * of this file and the file complex.c.)
 */

/***************************************************************************
 *                          Copyright (C) 1990 by                          *
 *        Mark B. Phillips, William M. Goldman, and Robert R. Miner        *
 *                                                                         *
 *  Permission to use, copy, modify, and distribute this software, its     *
 *  documentation, and any images it generates for any purpose and without *
 *  fee is hereby granted, provided that                                   *
 *                                                                         *
 *  (1) the above copyright notice appear in all copies and that both that *
 *      copyright notice and this permission notice appear in supporting   *
 *      documentation, and that the names of Mark B.  Phillips, William M. *
 *      Goldman, Robert R.  Miner, or the University of Maryland not be    *
 *      used in advertising or publicity pertaining to distribution of the *
 *      software without specific, written prior permission.               *
 *                                                                         *
 *  (2) Explicit written credit be given to the authors Mark B. Phillips,  *
 *      William M. Goldman, and Robert R. Miner in any publication which   *
 *      uses part or all of any image produced by this software.           *
 *                                                                         *
 * This software is provided "as is" without express or implied warranty.  *
 ***************************************************************************/

#ifndef COMPLEX_INCLUDED
#define COMPLEX_INCLUDED

typedef struct Complex_s {
	double	re,im;		/* real and imag parts */
	char	inf;		/* infinity flag: 0=finite, 1=infinite */
	} Complex;

/* NOTE: when inf=1, the values of re and im are meaningless */

extern Complex C_ZERO, C_ONE, C_NEG_ONE, C_NEG_I, C_I, C_INFINITY;
extern char *c_error;

double c_enorm(), c_enorm_sq(), c_edist(), c_arg();

#define C_NEG(z1,z2) c_neg(&(z1),&(z2))
#define C_COPY(z1,z2) c_copy(&(z1),&(z2))
#define C_ENORM(z) c_enorm(&(z))
#define C_ENORM_SQ(z) c_enorm_sq(&(z))
#define C_EDIST(z1,z2) c_edist(&(z1),&(z2))
#define C_ISEQUAL(z1,z2) c_isequal(&(z1),&(z2))
#define C_BAR(z1,z2) c_bar(&(z1),&(z2))
#define C_ADD(w,z1,z2) c_add(&(w),&(z1),&(z2))
#define C_SUB(w,z1,z2) c_sub(&(w),&(z1),&(z2))
#define C_MUL(w,z1,z2) c_mul(&(w),&(z1),&(z2))
#define C_DIV(w,z1,z2) c_div(&(w),&(z1),&(z2))
#define C_CROSS_RATIO(w,z1,z2,z3,z4) \
		c_cross_ratio(&(w),&(z1),&(z2),&(z3),&(z4))
#define C_PUSH_S(z) c_push_s(&(z))
#define C_POP_S(z) c_pop_s(&(z))
#define C_ARG(z) c_arg(&(z))
#define C_SCA_MUL(z1,s,z2) c_sca_mul(&(z1),s,&(z2))
#define C_SQRT(s,z) c_sqrt(&(s),&(z))

#endif
