


/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota 
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */



#ifndef LISTDEF
#define LISTDEF

#include "oogl/geomclass.h"
#include "oogl/bbox.h"

typedef struct list {
    Geom *car;
    struct list *cdr;
} List;

extern GeomClass *ListMethods( void );
extern char *ListName( void );
extern List *ListPrint( List * );
extern List *ListCreate( Geom *car, List *cdr );
extern List *ListLoad( char * );
extern List *ListFLoad( FILE * );
extern BBox *ListBound( List *, Transform );
extern List *ListTransform( List *, Transform );
extern List *ListRotate( List *, float, Point * );
extern List *ListTranslate( List *, float, float, float );
extern List *ListScale( List *, float, float, float );
extern List *ListEvert( List * );
extern Geom *ListReplace( List *, Geom * );
extern Geom *ListPick( List *, Transform T, double x, double y, float *z );
extern Geom *ListPickPoint( List *, Transform T, double x, double y, float *z,Point *pt);
extern Geom *ListPickPlane( List *, Transform T, double x, double y, float *z,Plane *pl);
extern Geom *ListPickLine( List *, Transform T, double x, double y, float *z, Line *ln);
extern List *ListDraw( List *, ContextObject * );
extern List *ListDrawIrisGl( List *, ContextObject * );
extern List *ListDrawRenderman( List *, ContextObject * );
extern List *ListDrawXWindows( List *, ContextObject * );
extern List *ListDelete( List * );
extern List *ListSave( List *, char * );
extern List *ListFSave( List *, FILE * );

#ifdef GEOM_SM
typedef struct sharedlist {
    SharedGeom *car;
    struct sharedlist *cdr;
} SharedList;

SharedList *ListShare();
List *ListPrivate();
#endif /*GEOM_SM*/

#endif /*LISTDEF*/
