


/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota 
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */



#ifndef	BBOXDEF
#define BBOXDEF

#include "oogl/geom.h"
#include "oogl/vert.h"

/*
 * The vert[] array lists vertices, indexed by binary order of initial axes,
 * where X has weight 1, Y weight 2, Z weight 4.
 * Initially "min" corresponds to 0, "max" to 1.
 * Specifically BBoxCreate(min, max) creates a bbox with:
 *  vert[0] = (min.x, min.y, min.z)
 *  vert[1] = (max.x, min.y, min.z)
 *  vert[2] = (min.x, max.y, min.z) ...
 *  vert[7] = (max.x, max.y, max.z).
 * Note this property isn't necessarily preserved if the bbox is transformed.
 */

#define BBOX_P VERT_P
typedef struct {
	int             bboxflag;
	Point3		min, max;
} BBox;

#define GeomBBoxCreate(min,max) \
	GeomCreate((GeomRef)BBoxCreate(min,max),BBoxMethods())

extern GeomClass *BBoxMethods( void );
extern char    *BBoxName( void );
extern BBox    *BBoxBound( BBox *, Transform );
extern BBox    *BBoxCopy( BBox * );
extern BBox    *BBoxCreate( Point3 *min, Point3 *max );
extern BBox    *BBoxDelete( BBox * );
extern BBox    *BBoxDraw( BBox *, ContextObject *object_context );
extern BBox    *BBoxDrawRenderman( BBox *, ContextObject *object_context );
extern BBox    *BBoxDrawIrisGl( BBox *, ContextObject *object_context );
extern BBox    *BBoxDrawXWindows( BBox *, ContextObject *object_context );
extern BBox    *BBoxTransform( BBox *, Transform );	/* Overwrites input! */
extern BBox    *BBoxMinMax( BBox *, Point3 *min, Point3 *max );
extern BBox    *BBoxUnion( BBox *, BBox * );

#ifdef GEOM_SM
extern GeomRef BBoxShare( Geom *obj, GeomSMRegion *sm );
#endif

#endif
