/****************************************************
*
*  Function: diffuse()
*
*  Purpose:  Diffuse mass through permeable surfaces.
*            Assumes string lengths or film areas
*            already calculated; also assumes pressures
*            known.
*/

#include "include.h"
  
/****************************************************
*
*  Function: diffuse()
*
*  Purpose:  Diffuse mass through permeable surfaces.
*            Assumes string lengths or film areas
*            already calculated; also assumes pressures
*            known.
*/

void diffuse()
{
  edge_id e_id;
  facet_id f_id;
  facetedge_id fe_id;
  body_id b_id,bb_id;
  REAL pressure;
  REAL mass;

  if ( web.dimension == STRING )
    {
      FOR_ALL_EDGES(e_id)
        {
          fe_id = get_edge_fe(e_id);
          if ( !valid_id(fe_id) ) return;
          b_id = get_facet_body(get_fe_facet(fe_id));
          if ( !valid_id(b_id) ) invert(fe_id);
          b_id = get_facet_body(get_fe_facet(fe_id));
          if ( !valid_id(b_id) ) continue;
          pressure = get_body_pressure(b_id);
        
          if ( !equal_id(fe_id,get_next_facet(fe_id)) )
           {
             fe_id = get_next_facet(fe_id);
             bb_id = get_facet_body(get_fe_facet(fe_id));
             if ( !valid_id(bb_id) ) invert(fe_id);
             bb_id = get_facet_body(get_fe_facet(fe_id));
             pressure -= get_body_pressure(bb_id);
           }
          else bb_id = NULLBODY;
        
          mass = web.scale*web.diffusion_const*pressure*get_edge_length(e_id);
          set_body_fixvol(b_id,get_body_fixvol(b_id)-mass);
          if ( valid_id(bb_id) )
            set_body_fixvol(bb_id,get_body_fixvol(bb_id)+mass);
        }
    }
  else if ( web.dimension == SOAPFILM )
    {    
      FOR_ALL_FACETS(f_id)
        {
          pressure = 0.0;
          b_id = get_facet_body(f_id);
          if ( valid_id(b_id) ) 
           pressure = get_body_pressure(b_id);
          else pressure = web.pressure;
        
          bb_id = get_facet_body(inverse_id(f_id));
          if ( valid_id(bb_id) )
             pressure -= get_body_pressure(bb_id);
          else pressure -= web.pressure;
        
          mass = web.scale*web.diffusion_const*pressure*get_facet_area(f_id);
          if ( valid_id(b_id) )

            set_body_fixvol(b_id,get_body_fixvol(b_id)-mass);
          if ( valid_id(bb_id) )
            set_body_fixvol(bb_id,get_body_fixvol(bb_id)+mass);
        }
    }
}
