/****************************************************************************\
*                                                                            *
*  THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE  *
*     WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR     *
*   PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.   *
*                                                                            *
*     In no event will the supplier be liable for any lost revenue           *
*   or profits or other special, indirect and consequential damages, even    *
*    if the supplier has been advised of the possibility of such damages.    *
*                                                                            *
*             Users may copy or modify this file without charge,             *
*       but are NOT authorized to license or sell it to anyone.              *
*                                                                            *
\****************************************************************************/

/****************************************************************************\
*                                                                            *
*    If you modify this software, you should include a notice giving the     *
* name of the person performing the modification, the date of modification,  *
* and the reason for such modification.  Bug reports or fixes should be sent *
*        to the author, who may or may not act on them as he desires:        *
*                                                                            *
* Internet: raytrace@cutmcvax.cs.curtin.edu.au                               *
*                                                                            *
* Mail   : School of Computer Science         | Tel: 619 351 7680            *
*          Curtin University of Technology    | Fax: 619 351 2819            *
*          Kent Street, Bentley                                              *
*          Western Australia, 6102                                           *
*                                                                            *
\****************************************************************************/

/*
 Copyright (c) 1990 Fred Parke.
 Modification: 1991 Andrew Marriott.
 */

#include "face.h"
#include "face_data.h"



/*  skip  --  skip over characters in a string
 *
 *  p = skip (charset,string);
 *  char *p,*charset,*string;
 *
 *  returns the address of the first character in the string which
 *  matches any of the characters in the charset; or the address of the
 *  null character at the end of the string;
 */

char *skip (set,str)
char *set,*str;
{
register char *setp,*strp;       /* fast pointers */
register int found;              /* done yet? */

	found = 0;
	strp = str;                      /* begin at first char */

	while (*strp && !found)
	{        /* until null or found */
		for (setp=set; (*setp) && *setp != *strp; setp++) ;
			/* find first char in set which matches current
			* char in str; or null at the end of set */

		if (*setp) strp++;            /* not found yet */
		else found = 1;
	}

	return (strp);
}

/*  skipx  --  skip over characters in a string
*
*  p = skipx (charset,string);
*  char *p,*charset,*string;
*
*  returns the address of the first character in the string which
*  does not match any of the characters in the charset; or the address of the
*  null character at the end of the string;
*/

char *skipx (set,str)
char *set,*str;
{
register char *setp,*strp;       /* fast pointers */
register int found;              /* done yet? */

	found = 0;
	strp = str;                      /* begin at first char */

	while (*strp && !found)
	{        /* until null or found */
		for (setp=set; (*setp) && *setp != *strp; setp++) ;
			/* find first char in set which matches current
			* char in str; or null at the end of set */

		if (*setp) found = 1;	    /* matches a char */
		else strp++;
	}

	return (strp);
}

/*	routine to convert polygon vertex identifiers in	*/
/*	the topology file into internal indices.		*/
/*								*/
/*	converts "m.n" format into m and n indices		*/

ftoii(p,i,j)
char *p;
int *i,*j;
{
char *q,*r;
	*i=0; *j=0;
	while(*p==' '||*p=='\t') p++;

	if (*p != '\0')
	{
		*i=atoi(p);
		q=skipx(" \t",p);
		r=skipx(".",p);
		if (r<q)
		{
			p=r+1;
			*j=atoi(p);
		}
		else *j=1;
	}
}

/*	rountine to read in vertex points file	*/

int readpt(pts,filename)
float pts[300][3];
char *filename;
{
int i, index, number_of_entries, number_points;
char line[80];
FILE *fp, *fopen();

	if((fp = fopen(filename,"r")) == NULL)
	{
		fprintf(stderr,"Cannot read file %s\n",filename);
		exit(-1);
	}
	fgets(line,80,fp);
/*	printf("%s",line);/**/
	fgets(line,80,fp);
	sscanf(line,"%d %d",&number_points,&number_of_entries);

	for (i=0; i<number_of_entries; i++)
	{
		do {
			fgets(line,80,fp);
		   } while(line[0] == '#');

		sscanf(line,"%d",&index); 
		sscanf(line,"%*d %f %f %f",
			&pts[index][0],&pts[index][1],&pts[index][2]);
	}
	fclose(fp);
	return(number_points);
}

/*	routine to read in polygon topology file	*/

int readt(Pc,Pg,Pgni,filename)
int Pc[300], Pg[300][4], Pgni[400][4];
char *filename;
{
int i, j, number_of_gs;
char *p, line[80];
FILE *fp, *fopen();

	if((fp = fopen(filename,"r")) == NULL)
	{
		fprintf(stderr,"Cannot read file %s\n",filename);
		exit(-1);
	}
	fgets(line,80,fp);
/*	printf("%s",line);/**/

	fgets(line,80,fp);
	sscanf(line,"%d",&number_of_gs);
	Pc[0]=0;

	for (i=1; i<=number_of_gs; i++)
	{
		do {
			fgets(line,80,fp);
		   } while(line[0] == '#');

		sscanf(line,"%d",&Pc[i]);
		object_is_visible[Pc[i]] =1;
		p=line;
		p=skipx(" \t",p);
		for (j=0; j<4; j++)
		{
			ftoii(p,&Pg[i][j],&Pgni[i][j]);
			p=skip(" \t",p);
			p=skip("0123456789.-",p);
		}
	}
	fclose(fp);
	return(number_of_gs);
}

/*	routine to rotate jaw vertices	*/

jrot(i,sa,ca,pt)
register int i;
float sa,ca;
register float pt[300][3];
{
float x,z;
	x=pt[i][0]-pt[107][0];
	z=pt[i][2]-pt[107][2];
	pt[i][0]=x*ca+z*sa+pt[107][0];
	pt[i][2]=z*ca-x*sa+pt[107][2];
}

/*	routine to "rotate" jaw vertices	*/
/*	only in the vertical direction		*/

jzrot(i,sa,ca,pt)
register int i;
float sa,ca;
register float pt[300][3];
{
float x,z;
	x=pt[i][0]-pt[107][0];
	z=pt[i][2]-pt[107][2];
	pt[i][2]=z*ca-x*sa+pt[107][2];
}
static void get_parm()
{
int done =0;
int ch,n,i,j;
char c,line[80];

	wintitle("q to quit");
	while(done == 0)
	{
		printf("\n>");
		while((ch=fgetc(stdin)) == ' ');ungetc(ch,stdin);
	
		if (ch=='p')	/*	change parameter value	*/
		{
			while((ch=fgetc(stdin)) == ' ');ungetc(ch,stdin);
			if(ch=='\n')
				printf("parameter number = ");
			fscanf(stdin,"%d",&n);
			while((ch=fgetc(stdin)) == ' ');ungetc(ch,stdin);
			if(ch=='\n')
				printf("parameter value = ");
			fscanf(stdin,"%f",&parameter[n].value);
			while((ch=fgetc(stdin)) != '\n');
		  	update_face_display();
		}
		else if (c=='r')	/*	read parameter value	*/
		{
			while((ch=fgetc(stdin)) == ' ');ungetc(ch,stdin);
			if(ch=='\n')
				printf("parameter number = ");
			fscanf(stdin,"%d",&n);
			printf("parameter value = %f\n",parameter[n].value);
			while((ch=fgetc(stdin)) != '\n');
		}
		else if (c=='q')	/*	termination		*/
			done=1;
		else printf("command error, try again\n>");
	}
	wintitle("fascia");
}
static int adjust(dist, pitch, roll)
float *dist;
float *pitch, *roll;
{
static float		velocity 	= 0.0;
static float		delta_velocity 	= 0.01;
static float		old_roll 	= -1;
static float		old_pitch	= -1;

	*pitch = (180/640.0*(getvaluator(MOUSEX)-640)) ; 
	*roll = ( 90 + 180/512.0*(getvaluator(MOUSEY)-512)) ;      

	if((old_pitch== *pitch) && (old_roll== *roll) )
		return(0);

	if(getbutton(LEFTMOUSE)) 	velocity -= delta_velocity;
	if(getbutton(MIDDLEMOUSE)) 	velocity += delta_velocity;
	if(getbutton(RIGHTMOUSE)) 	velocity  = 0.0;

	*dist +=  velocity;
	return(1);
}

void display_objects()
{
int change_occurred=1;

	unqdevice(MENUBUTTON);
	wintitle("ESC to end");

	while(!getbutton(ESCKEY))
	{
	    if(change_occurred)
	    	display_face();
	    change_occurred=adjust(&parameter[51].value, &parameter[52].value, &parameter[53].value);
	}

	wintitle("fascia");
	unqdevice(ESCKEY);
	qdevice(MENUBUTTON);
}
update_pic()
{
long menu_id;
Boolean quit;
	qdevice(MENUBUTTON);
	qdevice(REDRAW);
	menu_id = defpup("Draw %t|set orientation|set parameters|quit %x9");

	CALLOBJS;
	quit = FALSE;
	while(!quit)
	{
		short data;

		switch(qread(&data))
		{
			case REDRAW :
				winset(face_window);
				reshapeviewport();
				display_face();
				break;
			case MENUBUTTON :
			{
				switch(dopup(menu_id))
				{
					case 1 :
						display_objects(); break;

					case 2 :
						get_parm(); break;

					case 9 :
						quit = TRUE; break;
				}
			}
			break;
		}
	}

	gexit();
}
