/******
  
  pick.c:	Used for finding out the location/vertex number ofg
              points on the screen. It usually works but sometimes
	      it doesn't hmm...I must be doing something wrong
	      but I don't know what!

	      Pick by pushing the Middle Mouse button while over a vertex
	      in the Faceial Display Window.

This code was written with time and equipment provided by Sony Computer
Science Lab. It is freely distributable for research purposes. 

It is hoped making this available will facilitate research on facial
animation. If you make significant changes/extensions to this, or have
a different system I would appreciate hearing about it.


The latest versions of this and other animation systems are
available by anonymous FTP from:
     
        scslwide.sony.co.jp
	ftp2/SGI/Facial-Animation

  Copyright 1992	

  Written:	Steve Franks
                Sony Computer Science Labs
		Tokyo, Japan	
		Febuary 1992
		stevef@csl.sony.co.jp


*******/
#include <gl/gl.h>
#include <forms.h>
#include <sys/types.h>
#include <malloc.h>
#include "standard.h"
#include "proto.h"

extern 	float *face;
extern	cntrl_options	option;

	int		rx,ry,rz,tx,ty,tz;

/*** select_vertex() -- the middle mouse  in the face display window ***/
void	select_vertex(long	fgid)
{
   
    int		vert_num,i,indx;


    vert_num =	choose_vertex();
    if (vert_num==0) 	{
	printf("No vertex was choosen \07! \n");
	return;
    }

    indx = (vert_num)*3-2;
   
    printf("You have choosen Vertex Index # %d \n",vert_num);
    printf("Coordinates: (%5.3f, %5.3f, %5.3f )\n",face[indx],face[indx+1],
	   face[indx+2]);
}




   
/*** choose_vertex -- see what is closest to the cursor (if any) ***/
int choose_vertex(long fgid)
{
    short	pick_buf[50];
    long	hits;
    int 	i,j,k;
    int		indx;

     

    /** See if the currect cursor is near a vertex **/
    pushmatrix();
    pushattributes();
    winset(fgid);
    initnames();			/* clear the picking stack */
    pick(pick_buf,45); 

    if (option.ortho)     ortho(WINXS,WINXE,WINYS,WINYE,WINZS,WINZE);
    else	  {  window(P_WINXS,P_WINXE,P_WINYS,P_WINYE,P_WINZS,P_WINZE); 
		     translate(0,0,-20); 	/* to move along z-axis */
		 };


    
    /* Rotate and Translate the head (controlled via keypad) */
    translate(tx,ty,tz);
    rotate(rx,'x');
    rotate(ry,'y');
    rotate(rz,'z');


    indx = 1;
    for (i=1; i<=face[0]; i++) { /* Loop thru points */
	loadname(i);
	bgnpoint();
	v3f(&face[indx]);
	indx += 3;
	endpoint();
    }
    hits = endpick(&pick_buf[0]); 
    if (hits>0) hits = pick_buf[1];
    init_gl_env();	/* to stop to zooming problem */ 
    popattributes();
    popmatrix();
    return(hits);
}








