#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "library.h"
#include "winman.h"
#include "actor.h"
#include "debug.h"

extern "C" {
#include <forms.h>

}

extern	Winman mngr;

char * set_file(void)
{
    
    static char	*dir=0;
    char	*file,*st;
    static char	ans[100];

    st=fl_show_file_selector("Choose Scene Parameter File",dir,"*","smile");

    if (st==NULL) 
	return((char *)-1);
    
    file = fl_get_filename();
    dir =  fl_get_directory();

    
    // I assume the widget reuses the name space so I don't free

    sprintf(ans,"%s/%s",dir,file);
    return(ans);
}


/*** load_scene -- interactively get a file name and load ***/
int load_scene(char *title,long id)
{
    char	*file;
    int		bid;

    file = set_file();
    status("file",file);
    if ((int)file== -1)
      return(-1);

    load_scene(title,id,file);

    return(bid);
}


/*** load_scene -- load a scene using the specified file name ***/
int  load_scene(char *title,long id,char *file)
{
   
    int 	num_boards,i,i2,st;
    int		start,stop,num_pts;
    FILE	*fd;
    char	old_title[80],actor_title[80];

    float	xpos,ypos;
    
    long  	brd;
    Actor 	*temp;

    status("Loading a scene from file",file);
    fd = fopen(file,"r");
    if ( (int)fd<=0) {
	status("Trouble Reading from File",file);
	perror("Reason");
	return(-1);
    }
    st =fscanf(fd,"%s%d",old_title,&num_boards);
    if (st!=2) {
	status("FATAL Error: Reading ",file);
	perror("reason");
	exit(-1);
    }
    
    if (title==NULL) {
	title = (char *) malloc(sizeof(char)*(strlen(old_title)+1));
	sprintf(title,"%s",old_title);
    }

    status("Opening the Board",title);
    brd = mngr.create_board(title,7,num_boards);
    status("Reading in the Actors");
    for (i=0;i<num_boards; i++) {
	st=fscanf(fd,"%s%d%f%f%d",actor_title,&id,&start,&stop,&num_pts);
	if (st!=5) {
	    status("ERROR: Reading header for spline data",i);
	    status("From File",file);
	    status("Board titles MAYNOT have spaces -- please check");
	    exit(-1);
	}	


	status("Opening New Actor",actor_title);
	temp= new Actor(num_pts,actor_title,id);
	
	status("Loading Data Points",num_pts);
	for (i2=0;i2<num_pts;i2++) {
	    st =fscanf(fd,"%f%f",&xpos,&ypos);
	    if (st!=2) {
		status("ERROR reading data from ",file);
		perror("Reason");
		exit(-1);
	    }
	    status("Xpos",xpos);
	    status("Ypos",ypos);
	    temp->eq(i2,xpos,ypos);
	}
	status("Registering the Actor on brd",brd);
	mngr.register_actor(brd,temp->title,temp->id,temp);
    }
    
    fclose(fd);
    return(brd); 
}

/*** save_scene -- interactively get file name to save in and save scene ***/
int save_scene(long bid)
{
    char	*file;
    int		st;

    file = set_file();
    if ((int)file==-1) {
	status("Scene not saved");
	st = -1; 
    }
    else {
	st=save_scene(bid,file);
    }

    return(st);
}



/*** save_scene -- save a scene with the specified file name ***/
int save_scene(long brd,char *file)
{
    int		i,i2,num_pts,num_act;
    char	f[100], *new_title;
    FILE	*fd;
    Board	*b;
    
    
    b = mngr.b[brd];
    fd = fopen(file,"w");
    status("Overwriting/Creating File",f);
    
    if ((int)fd<=0) {
	status("WARNING::Can't open file for writing",f); 
	perror("Reason:");
	return(-1);
    }
    

    new_title=fl_show_input("Enter Scene Name to Save As",b->scene_title);
    
    num_act = b->num_act; 
    fprintf(fd,"%s\t%d\n",new_title,num_act);
    
    for (i=0;i<num_act; i++) {
	num_pts = b->obj[i]->num_pnts();
	fprintf(fd,"%s\t%d\t%5.4f\t%5.4f\t\%d\n",b->obj[i]->title,
		b->obj[i]->id,b->start_x,b->end_x,num_pts);
	
	for (i2=0;i2<num_pts;i2++)
	  fprintf(fd,"%5.4f\t%5.4f\n",b->obj[i]->xpos(i2),
		  b->obj[i]->ypos(i2));
	
    }
    
    fprintf(fd,"\n");
    fclose(fd);
    return(TRUE);
}










