#ifndef _actor.h_

#define _actor.h_ 

#include <gl/gl.h>
#include <stdio.h>
#include "debug.h"

#define TITLE_LEN 	50
#define L_BORDER 	30
#define R_BORDER	10
#define YMAX	500
#define YMIN    -10
#define ORTHO ortho2(disp_st - L_BORDER,disp_end-R_BORDER,-10,YMAX) 

#define CNTRL_PNT_RADIUS 10
#define CARD_BASIS 1


static float cspline_matrix[4][4] = {
    { -0.5, 1.5, -1.5, 0.5},
    {  1.0,-2.5,  2.0,-0.5},
    { -0.5,   0,  0.5, 0},
    {    0,   1,  0  , 0}
};




class Actor {
    
  public:
    char	title[TITLE_LEN];	
    long	id;		// unique ID number

    Actor(int,char *,long);
    ~Actor();
   
    float xpos(int i) {
	if (i>num_pts) {
	    status("Illegal xpos call \07",i);
	    return(7777777); 
	}
	else return(pnts[i*3]); }
    float ypos(int i) { return(pnts[i*3+1]); }  
    int	  num_pnts()   { return(num_pts); }
    void eq(int i,float x,float y) {pnts[i*3]=x; pnts[i*3+1]=y; }
    void reset();
    void add_pnt(float x,float y);
    void del_pnt(int i);
    int  find_pnt();	
    void append(Actor *,float );
    void prepend(Actor *,float);

    float start() { return(xpos(0)); };		// return(st_x)???
    float end()   { return(xpos(num_pts-1));};	// return(end_x)???
    float get_value(float);
    
    void gl_event(long,short,int);		// handle GL callbacks
    void draw(float, float,float); 			// draw subregion
    void draw() {draw(disp_st, disp_end,-1.0);};	// draw whole spline
    void draw(float x) {draw(disp_st,disp_end,x);};
    void draw_pts();				// just the cntrl points
    void draw_cursor(float);			
    void	setup_coeff();	// setup and recalc ALL the coeff
    void set_window(float p1,float p2) 
      {	
	  /* This rescales each actor independantly,  which maybe OK
	    if a scale is drawn, but also what to have them synced
	      by using the Board start_x and end_x values. */
	  disp_st = (end()-start())*p1+st_x;
	  disp_end= disp_st +(end()-start())*p2;
	  status("Start,end = ",start(),end());
	  status("Disp st,end",disp_st,disp_end);
	  status("Params",p1,p2);
      }


  private:
    int		pts_flag;	// if # of points have changed
    int		coeff_flag;	// a point has been moved (not yet used)
    int 	num_pts;
    float 	*pnts;
    float	*spl_coeff;	// type define this better 
    float	st_x;		// first xposition of the spline
    float	end_x;		// last xposition of the spline
    float	disp_st;	// start of display window
    float	disp_end;
  

    float 	value(float ,float [4][2]);
    void	calc_coeff(float [4][3], float [4][2]); 

};

#endif






















