/*ScianDraw.h
  External stuff for ScianDraw.c
  Eric Pepke
  March 28, 1990
*/

/*Structure to contain drawing state*/
typedef struct
    {
	WinInfoPtr window;		/*Current window into which drawing is done*/
	Bool initialWindow;		/*True iff initial window pressing*/
	int origin[2];			/*Origin of the window*/
	int viewport[4];		/*Viewport mapped to ortho or perspec*/
	int screenMask[4];		/*Screen mask within window*/
	int translation[2];		/*Translation within window*/
    } DrawingState;			/*Drawing state*/

#define NDRAWINGSTATES		200	/*Maximum number of saved drawing states*/
extern DrawingState drawingStates[NDRAWINGSTATES];
					/*Stack of drawing states*/
extern int curDrawingStateIndex;	/*Current drawing state index*/
extern Bool fullScreen;			/*True iff drawing into full screen*/

#define CURSTATE	(drawingStates[curDrawingStateIndex])
#define LASTSTATE	(drawingStates[curDrawingStateIndex - 1])
#define NEXTSTATE	(drawingStates[curDrawingStateIndex + 1])

extern Bool drawMouse;			/*True iff draw on next mouse*/
extern int drawingMode;			/*Drawing mode*/
extern FILE *drawFile;			/*File in which to draw*/

#define IsDrawingRestricted(l, r, b, t) (		 		\
	(l) > CURSTATE . screenMask[1] - CURSTATE . translation[0] ||	\
	(r) < CURSTATE . screenMask[0] - CURSTATE . translation[0] ||	\
	(b) > CURSTATE . screenMask[3] - CURSTATE . translation[1] ||	\
	(t) < CURSTATE . screenMask[2] - CURSTATE . translation[1])	\

#define PSM printf("Local mask = %d %d %d %d, bwana\n", 		\
	CURSTATE . screenMask[0] - CURSTATE . translation[0],		\
	CURSTATE . screenMask[1] - CURSTATE . translation[0],		\
	CURSTATE . screenMask[2] - CURSTATE . translation[1],		\
	CURSTATE . screenMask[3] - CURSTATE . translation[1]);


/*Values for drawing mode*/
#define DRAW_SCREEN	1	/*Drawing to the screen*/
#define DRAW_POSTSCRIPT	2	/*Drawing to a postscript file*/

/*Arrowhead styles*/
#define AH_NO_ARROW	0
#define AH_AT_START	1
#define AH_AT_END	2
#define AH_BOTH_ENDS	(AH_AT_START | AH_AT_END)

/*Method declarations*/
ObjPtr PressObject();

#ifdef PROTO
void DrawObject(ObjPtr);
ObjPtr KeyDownObject(ObjPtr obj, int key, long flags);
void SetOrigin(int, int);
void RestoreOrigin(void);
void SetDrawingWindow(WinInfoPtr);
void RestoreDrawingWindow();
void SetSubPort(int, int, int, int);
void RestoreSubPort(void);
void SetClipRect(int, int, int, int);
void RestoreClipRect(void);
void ClipToMe(ObjPtr);
void RegisterInSpace(Bool);
void EndRegister(void);
void CurOffset(int *, int *);
ObjPtr DropObjects(ObjPtr, ObjPtr, int, int);
void UpdateDrawing(void);
void FrameUIRect(int, int, int, int, int);
void FillUIRect(int, int, int, int, int);
void FillUIGauzeRect(int, int, int, int, int);
void FrameRect(int, int, int, int);
void FillRect(int, int, int, int);
void DrawUILine(int, int, int, int, int);
void DrawUILine(int, int, int, int, int);
void DrawLine(int, int, int, int);
void DrawWFSphere(real, real, real, real);
void DrawSpaceLine(real x1, real y1, real z1, real x2, real y2, real z2);
void DrawSpaceString(real x, real y, real z, char *s);
void DrawSpacePanelLine(real x1, real y1, real x2, real y2, real width, int arrow,
                real arrowParams[4][2]);
void DrawVCursor(int, int, int);
void FrameUIWideRect(int, int, int, int, int, int);
void FrameWideRect(int, int, int, int, int);
void DrawHandle(int, int);
Bool PointInHandle(int, int, int, int);
void MakeOrthoXform(void);
void DrawRaisedEdge(int left, int right, int bottom, int top);
void DrawSunkenEdge(int left, int right, int bottom, int top);
void DrawInsetRect(int left, int right, int bottom, int top);
void DrawRaisedRect(int left, int right, int bottom, int top, int uiColor);
void DrawSunkenRect(int left, int right, int bottom, int top, int uiColor);
void FillTri(int, int, int, int, int, int);
void FillUITri(int, int, int, int, int, int, int);
void SetLineWidth(int width);
void DrawMarkerSplat(int, int, int, int);
void DrawMarkerBlot(int, int, int, int);
void DrawMarkerCheck(int, int, int, int);
void DrawMarkerX(int, int, int, int);
void FillUIWedge(int, int, int, int, int, int);
void FillUIDisc(int, int, int, int);
void FillUIGauzeDisc(int, int, int, int);
void DrawCtlLeft(int left, int right, int bottom, int top, int uiColor);
void DrawCtlRight(int left, int right, int bottom, int top, int uiColor);
void DrawCtlUp(int left, int right, int bottom, int top, int uiColor);
void DrawCtlDown(int left, int right, int bottom, int top, int uiColor);
void BeginDrawing(char *, int, int, int, int);
void EndDrawing(void);
void FillRealRect(real, real, real, real);
void FrameRealWideRect(real, real, real, real, real);
void FillRealQuad(real, real, real, real, real, real, real, real);
void InitDraw(void);
void KillDraw(void);
void FullScreen(Bool);
#else
void DrawObject();
ObjPtr KeyDownObject();
void SetDrawingWindow();
void RestoreDrawingWindow();
void SetSubPort();
void RestoreSubPort();
void SetClipRect();
void RestoreClipRect();
void SetOrigin();
void RestoreOrigin();
void ClipToMe();
void RegisterInSpace();
void EndRegister();
Bool Mouse();
ObjPtr DropObjects();
void CurOffset();
void UpdateDrawing();
void FrameUIRect();
void FillUIRect();
void FillUIGauzeRect();
void FrameRect();
void FillRect();
void DrawUILine();
void DrawLine();
void DrawWFSphere();
void DrawSpaceLine();
void DrawSpaceString();
void DrawSpacePanelLine();
void DrawVCursor();
void FrameUIWideRect();
void FrameWideRect();
void DrawHandle();
Bool PointInHandle();
void MakeOrthoXform();
void DrawRaisedEdge();
void DrawSunkenEdge();
void DrawInsetRect();
void DrawRaisedRect();
void DrawSunkenRect();
void FillTri();
void FillUITri();
void SetLineWidth();
void DrawMarkerSplat();
void DrawMarkerBlot();
void DrawMarkerCheck();
void DrawMarkerX();
void FillUIWedge();
void FillUIDisc();
void FillUIGauzeDisc();
void DrawCtlLeft();
void DrawCtlRight();
void DrawCtlUp();
void DrawCtlDown();
void BeginDrawing();
void EndDrawing();
void FillRealRect();
void FrameRealRect();
void FillRealQuad();
void InitDraw();
void KillDraw();
void FullScreen();
#endif
