/*ScianDraw.h
  External stuff for ScianDraw.c
  Eric Pepke
  March 28, 1990
*/

extern Bool drawMouse;			/*True iff draw on next mouse*/
extern int drawingMode;			/*Drawing mode*/
extern FILE *drawFile;			/*File in which to draw*/
extern int originX, originY;		/*X and Y origins*/
extern Bool inSpace[];
extern int curInSpace;
extern int translations[][2];
extern int curTranslation;
extern Bool restrictedDrawing;		/*True iff restricted drawing*/
extern int rLeft, rRight, rBottom, rTop;/*Restricted bounds*/

#define IsDrawingRestricted(l, r, b, t) (restrictedDrawing && 	\
	((l) > rRight - translations[curTranslation][0] ||	\
	 (r) < rLeft - translations[curTranslation][0] || 	\
	 (b) > rTop - translations[curTranslation][1] ||		\
	 (t) < rBottom - translations[curTranslation][1]))

/*Values for drawing mode*/
#define DRAW_SCREEN	1	/*Drawing to the screen*/
#define DRAW_POSTSCRIPT	2	/*Drawing to a postscript file*/

/*Method declarations*/
ObjPtr KeyDownObject();
ObjPtr PressObject();

#ifdef PROTO
void DrawObject(ObjPtr);
void SetOrigin(int, int);
void RestoreOrigin(void);
void SetWindowArea(int, int, int, int);
void RestoreWindowArea(void);
void SetClipRect(int, int, int, int);
void RestoreClipRect(void);
void ClipToMe(ObjPtr);
void RegisterInSpace(Bool);
void EndRegister(void);
void CurOffset(int *, int *);
ObjPtr DropObjects(ObjPtr, ObjPtr, int, int);
void UpdateDrawing(void);
void GetOrigin(int *, int *);
void FrameUIRect(int, int, int, int, int);
void FillUIRect(int, int, int, int, int);
void FrameRect(int, int, int, int);
void FillRect(int, int, int, int);
void DrawUILine(int, int, int, int, int);
void DrawUILine(int, int, int, int, int);
void DrawLine(int, int, int, int);
void DrawWFSphere(real, real, real, real);
void DrawSpaceLine(real x1, real y1, real z1, real x2, real y2, real z2);
void DrawSpaceString(real x, real y, real z, char *s);
void DrawVCursor(int, int, int);
void FrameUIWideRect(int, int, int, int, int, int);
void FrameWideRect(int, int, int, int, int);
void DrawHandle(int, int);
Bool PointInHandle(int, int, int, int);
void MakeOrthoXform(void);
void DrawRaisedEdge(int left, int right, int bottom, int top);
void DrawSunkenEdge(int left, int right, int bottom, int top);
void DrawInsetRect(int left, int right, int bottom, int top);
void DrawRaisedRect(int left, int right, int bottom, int top, int uiColor);
void DrawSunkenRect(int left, int right, int bottom, int top, int uiColor);
void FillTri(int, int, int, int, int, int);
void FillUITri(int, int, int, int, int, int, int);
void SetLineWidth(int width);
void DrawMarkerSplat(int, int, int, int);
void DrawMarkerBlot(int, int, int, int);
void DrawMarkerCheck(int, int, int, int);
void DrawMarkerX(int, int, int, int);
void FillUIWedge(int, int, int, int, int, int);
void FillUIDisc(int, int, int, int);
void FillUIGauzeDisc(int, int, int, int);
void DrawCtlLeft(int left, int right, int bottom, int top, int uiColor);
void DrawCtlRight(int left, int right, int bottom, int top, int uiColor);
void DrawCtlUp(int left, int right, int bottom, int top, int uiColor);
void DrawCtlDown(int left, int right, int bottom, int top, int uiColor);
void BeginDrawing(char *, int, int, int, int);
void EndDrawing(void);
void FillRealRect(real, real, real, real);
void FrameRealWideRect(real, real, real, real, real);
void FillRealQuad(real, real, real, real, real, real, real, real);
void RestrictedDrawing(int, int, int, int);
void UnrestrictedDrawing(void);
#else
void DrawObject();
void SetOrigin();
void RestoreOrigin();
void SetWindowArea();
void RestoreWindowArea();
void SetClipRect();
void RestoreClipRect();
void ClipToMe();
void RegisterInSpace();
void EndRegister();
Bool Mouse();
ObjPtr DropObjects();
void CurOffset();
void UpdateDrawing();
void GetOrigin();
void FrameUIRect();
void FillUIRect();
void FrameRect();
void FillRect();
void DrawUILine();
void DrawLine();
void DrawWFSphere();
void DrawSpaceLine();
void DrawSpaceString();
void DrawVCursor();
void FrameUIWideRect();
void FrameWideRect();
void DrawHandle();
Bool PointInHandle();
void MakeOrthoXform();
void DrawRaisedEdge();
void DrawSunkenEdge();
void DrawInsetRect();
void DrawRaisedRect();
void DrawSunkenRect();
void FillTri();
void FillUITri();
void SetLineWidth();
void DrawMarkerSplat();
void DrawMarkerBlot();
void DrawMarkerCheck();
void DrawMarkerX();
void FillUIWedge();
void FillUIDisc();
void FillUIGauzeDisc();
void DrawCtlLeft();
void DrawCtlRight();
void DrawCtlUp();
void DrawCtlDown();
void BeginDrawing();
void EndDrawing();
void FillRealRect();
void FrameRealRect();
void FillRealQuad();
void RestrictedDrawing();
void UnrestrictedDrawing();
#endif
