/*External stuff for ScianScripts
*/

extern Bool runningScript;
extern Bool abortScript;

#define SKIPBLANKS(s) while (*s && isspace(*s)) ++s;
#define SHIFTKW(d, s) {int k; SKIPBLANKS(s); begToken = s; k = 0; while (*s && !isspace(*s)) {if (*s == '\\') ++s; d[k++] = *s++;} endToken = s; d[k] = 0;}
#define SHIFTFN(d, s) {int k; SKIPBLANKS(s); begToken = s; k = 0; while (*s && !isspace(*s)) {if (*s == '\\') d[k++] = *s++; d[k++] = *s++;} endToken = s; d[k] = 0;}
#define SHIFTNUM(d, s) {int k; SKIPBLANKS(s); begToken = s; k = 0; while (*s && (isalpha(*s) || isdigit(*s) || *s == '+' || *s == '-' || *s == '.')) {d[k++] = *s++;} endToken = s; d[k] = 0;}

extern char *begToken, *endToken;	/*Beginning and ending of current token*/

/*Logging information*/
extern Bool logging;
extern FILE *logFile;

#ifdef PROTO
void BeginScript(void);
void EndScript(void);
Bool InterpretScriptLine(char *);
ObjPtr FindFullNamedObject(char *);
void MakeFullObjectName(char *, ObjPtr, ObjPtr);
void MakeObjectName(char *, ObjPtr);
void Log(char *);
void LogControl(ObjPtr);
char *PrintScriptObject(char *, ObjPtr);
void InhibitLogging(Bool);
char *PrintScriptString(char *, char *);
#else
void BeginScript();
void EndScript();
Bool InterpretScriptLine();
ObjPtr FindFullNamedObject();
void MakeFullObjectName();
void MakeObjectName();
void Log();
void LogControl();
void InhibitLogging();
char *PrintScriptString();
#endif
