/*ScianMain.c
  Eric Pepke
  Main routines for SciAn
*/

#include "Scian.h"
#include "ScianTypes.h"
#include "ScianArrays.h"
#include "ScianLists.h"
#include "ScianEvents.h"
#include "ScianWindows.h"
#include "ScianObjWindows.h"
#include "ScianVisWindows.h"
#include "ScianDialogs.h"
#include "ScianDatasets.h"
#include "ScianColors.h"
#include "ScianControls.h"
#include "ScianIcons.h"
#include "ScianRecorders.h"
#include "ScianFiles.h"
#include "ScianGarbageMan.h"
#include "ScianScripts.h"
#include "ScianTimers.h"
#include "ScianErrors.h"
#include "ScianIDs.h"
#include "ScianSpaces.h"
#include "ScianPreferences.h"

Bool stuffInited = false;
extern Bool recordEnabled;
extern FILE *curScript;
Bool runningRemote = false;
real missingData = 1.1E37;
Bool demoP = false;

char **fonts;

extern Bool runningScript;	/*True iff running script*/

#ifdef CURSORS4D
/*Cursors*/
Cursor watchCursor = 
    {
	0x07e0,
	0x07e0,
	0x07e0,
	0x07e0,
	0x0810,
	0x1008,
	0x1008,
	0x11cc,
	0x110c,
	0x1108,
	0x1108,
	0x0810,
	0x07e0,
	0x07e0,
	0x07e0,
	0x07e0
    };
Cursor questionCursor = 
    {
	0x0300,
	0x0300,
	0x0000,
	0x0300,
	0x0300,
	0x0300,
	0x0380,
	0x0180,
	0x0070,
	0x0038,
	0x0018,
	0x1818,
	0x1818,
	0x1c38,
	0x0ff0,
	0x07e0
    };
Cursor iconCursor = 
    {
	0xFFFF,
	0xFFFF,
	0xFFFF,
	0xFFFF,
	0xFFFF,
	0xFFFF,
	0xFFFF,
	0xFFFF,
	0xFFFF,
	0xFFFF,
	0xFFFF,
	0xFFFF,
	0xFFFF,
	0xFFFF,
	0xFFFF,
	0xFFFF
    };
#endif

void ParseArgs(argc, argv)
int argc;
char *argv[];
/*Parses the arguments in argc and argv*/
{
    int k;
    char format[256];		/*Current file format*/
    ObjPtr corral;		/*Corral in the datasets window*/

    strcpy(format, "No Format");

    for (k = 1; k < argc; ++k)
    {
	/*Go through arguments, parsing them*/
	if (*argv[k] == '-')
	{
	    /*It's a switch*/
	    switch (argv[k][1])
	    {
		case 'f':
		    /*New file format*/
		    ++k;
		    if (k >= argc)
		    {
			/*No format specified!*/
			fprintf(stderr, "%s: -f must be followed by a format.\n", argv[0]);
			exit(-1);
		    }
		    strncpy(format, argv[k], 255);
		    format[255] = 0;
		    break;
		case '1':
		    /*One observer, clock, whatever*/
		    switch (argv[k][2])
		    {
			case 'c':
			case 'C':
			    oneClock = true;
			    break;
			case 'o':
			case 'O':
			    oneObserver = true;
			    break;
			case 'l':
			case 'L':
			    oneLights = true;
			    break;
			case 'r':
			case 'R':
			    oneRenderer = true;
			    break;
			case 'p':
			case 'P':
			    onePalette = true;
			    break;
			default:
			    fprintf(stderr, "%s: Unrecognized object type for -1 flag\n", argv[0]);
			    exit(-1);
		    }
		    break;
		case 's':
		    /*Script to run*/
		    ++k;
		    if (k >= argc)
		    {
			/*No script specified!*/
			fprintf(stderr, "%s: -s must be followed by a script name.\n", argv[0]);
			exit(-1);
		    }
		    if (curScript)
		    {
			fprintf(stderr, "%s: Only one script can be given on the command line.\n", argv[0]);
			exit(-1);
		    }
		    curScript = fopen(argv[k], "r");
		    if (curScript)
		    {
			runningScript = true;
			abortScript = false;
		    }
		    else
		    {
			fprintf(stderr, "%s: Cannot open file %s for reading.\n", argv[0], argv[k]);
		    }
		    break;
		case 'l':
		    /*Open log file*/
		    ++k;
		    if (k >= argc)
		    {
			/*No log file specified!*/
			fprintf(stderr, "%s: -s must be followed by a log file name.\n", argv[0]);
			exit(-1);
		    }
		    if (logFile)
		    {
			fprintf(stderr, "%s: Only one log file can be given on the command line.\n", argv[0]);
			exit(-1);
		    }
		    logFile = fopen(argv[k], "w");
		    if (logFile)
		    {
			logging = true;
		    }
		    else
		    {
			fprintf(stderr, "%s: Cannot open log file %s for writing.\n", argv[0], argv[k]);
		    }
		    break;
		case 'v':
		    /*Enable recording*/
		    blanktime(0);
		    recordEnabled = true;
		    break;
		case 'd':
		    /*Demo mode*/
		    demoP = true;
		    break;
		default:
		    /*Undefined switch*/
		    fprintf(stderr, "%s: Switch %s is undefined.\n", argv[0], argv[k]);
		    exit(-1);
	    }
	}
	else
	{
	    WinInfoPtr datasetsWindow;
	    /*It must be a file name*/

	    datasetsWindow = DatasetsWindow();

	    IdleAllWindows();
	    SelectWindow(datasetsWindow -> id);
	    corral = FindMainCorral(datasetsWindow);
	    LongOperation();
	    ReadFile(argv[k], format);
	}
    }
}

int nFonts = 0;
static int curFont;

main(argc, argv)
int argc;
char *argv[];
{
#ifdef IRIS
    foreground();
#endif
    InitNames();
    InitObjects();
    InitArrays();
    InitLists();
    InitRecorders();
    InitControls();
    MainWindow();
    ParseArgs(argc, argv);
    QueueDevices();
    InitEvents();
    MainLoop();
    KillEvents();
    UnqueueDevices();
    if (logging)
    {
	fclose(logFile);
    }
    if (recordEnabled)
    {
	blanktime(40000);
    }
    KillPreferences();
    DisposeAllWindows();
    KillColors();
    KillDialogs();
    KillObjWindows();
    KillWindows();
    KillPictures();
    KillVisObjects();
    KillVisWindows();
    KillTimers();
    KillSpaces();
    KillFilters();
    KillDatasets();
    KillIcons();
    KillControls();
    KillRecorders();
    KillJohnFiles();
    KillFiles();
    if (TrashDayFlag)
    {
        TrashDay();
    }

    KillLists();
    KillArrays();
    KillObjects();
    KillNames();
    for (curFont = 0; curFont < nFonts; ++curFont)
    {
	free(fonts[curFont]);
    }
    free(fonts);
    exit(0);
}

static void CountFonts(s)
char *s;
/*Counts the fonts*/
{
    ++nFonts;
}

static void RegisterFont(s)
char *s;
/*Counts the fonts*/
{
    fonts[curFont] = malloc(strlen(s) + 1);
    strcpy(fonts[curFont], s);
    ++curFont;
}

InitStuff()
/*Initializes stuff.  Has to be called after one window has been opened.*/
{
    if (!stuffInited)
    {
#ifdef FONTS4D
	nFonts = 0;
	fmenumerate(CountFonts);
	fonts = (char**) malloc(sizeof(char *) * nFonts);
	curFont = 0;
	fmenumerate(RegisterFont);
#else
	fonts = 0;
#endif
	InitIcons();
	InitSpaces();
	InitTimers();
	InitDatasets();
	InitFilters();
	InitFiles();
	InitJohnFiles();
	InitPictures();
	InitWindows();
	InitObjWindows();
	InitVisWindows();
	InitVisObjects();
	InitDialogs();
	InitColors();
	InitPreferences();

	/*Set up fonts*/
	InitFonts();

	/*Set up cursors*/
#ifdef CURSORS4D
#ifdef GL4D
	curstype(C16X1);
#endif
	defcursor(WATCHCURSOR, watchCursor);
	curorigin(WATCHCURSOR, 8, 8);
	defcursor(QUESTIONCURSOR, questionCursor);
	curorigin(QUESTIONCURSOR, 8, 8);
	defcursor(ICONCURSOR, iconCursor);
	curorigin(ICONCURSOR, 8, 8);
#endif
#ifdef GL4D
#ifdef IRIS
	glcompat(GLC_OLDPOLYGON, FALSE);
#endif
#endif
	stuffInited = true;
    }
}

