/* ScianTitleBoxes.c:	John R. Murray, 3-30-90
		purely stylistic screen display objects.
*/
#include "Scian.h"
#include "ScianTypes.h"
#include "ScianColors.h"
#include "ScianIDs.h"
#include "ScianErrors.h"
#include "ScianArrays.h"
#include "ScianWindows.h"
#include "ScianObjWindows.h"
#include "ScianStyle.h"
#include "ScianDraw.h"
#include "ScianControls.h"
#include "ScianFontSystem.h"
#include "ScianTextBoxes.h"

/* global define */
ObjPtr	titleBoxClass;

/* local constants */
#define LABELSPACER DEFTEXTSIZE	/* spacer from edge of box to start of text */
#define LINESPACER  5.0		/* spacer in pixels from text to lines */

ObjPtr	DrawTitleBox(theTitleBox, theParent)
ObjPtr	theTitleBox, theParent;
{
    int left, right, bottom, top;
    int xText, yText;
    ObjPtr   theLabel;
    char        *label;
    real	length;

    if (!Get2DIntBounds(theTitleBox, &left, &right, &bottom, &top))
    {
        return NULLOBJ;
    }

    if (IsDrawingRestricted(left, right, bottom, top))
    {
	return ObjFalse;
    }

    /* attempt to draw the title box label */
    theLabel = GetVar(theTitleBox, NAME);
    if (!theLabel)
    {
	DrawUILine(left, top, right, top, UITEXT);
	DrawUILine(right, top, right, bottom, UITEXT);
	DrawUILine(right, bottom, left, bottom, UITEXT);
	DrawUILine(left, bottom, left, top, UITEXT);
    }
    else
    {
	if (!(theLabel = GetStringVar("DrawTitleBox", theTitleBox, NAME)))
        {
	    label = "";
        }
	else
	{
            label = GetString(theLabel);
	}
        SetUIColor(UITEXT);
	SetupFont(DEFFONT, DEFTEXTSIZE);
	DrawAString(LEFTALIGN, left + LABELSPACER, top - DEFTEXTSIZE, label);
	length = StrWidth(label);

	/* Draw the box itself */
	DrawUILine(
		left + LABELSPACER - LINESPACER, top - DEFTEXTSIZE,
		left, top - DEFTEXTSIZE, UITEXT);
	DrawUILine(
		left, top - DEFTEXTSIZE,
		left, bottom, UITEXT);
	DrawUILine(
		left, bottom, right, bottom, UITEXT);
	DrawUILine(right, bottom,
		right, top - DEFTEXTSIZE, UITEXT);
	DrawUILine(right, top - DEFTEXTSIZE,
		left + length + LABELSPACER + LINESPACER, top - DEFTEXTSIZE, UITEXT);
    }
}

void	InitTitleBoxes()
{
    titleBoxClass = NewObject(controlClass, 0);
    AddToReferenceList(titleBoxClass);
    SetMethod(titleBoxClass, DRAW, DrawTitleBox);
}

void	KillTitleBoxes()
{
    RemoveFromReferenceList(titleBoxClass);
    titleBoxClass = 0;
}

ObjPtr	NewTitleBox(left, right, bottom, top, title)
int	left, right, bottom, top;
char	*title;
/* stylistic box with snazzy label */
{
    ObjPtr      retVal;
    ObjPtr      labelPtr;

    retVal = NewObject(titleBoxClass, 0);
    Set2DIntBounds(retVal, left, right, bottom, top);
    if (title)
    {
	labelPtr = NewString(title);
	SetVar(retVal, NAME, labelPtr);
    }
    return retVal;
}

