/*External stuff for ScianScripts
  Eric Pepke
*/

extern Bool runningScript;
extern Bool abortScript;
extern Bool settingUp;

#define SHIFTKW(d, s) {int k; SKIPBLANKS(s); begToken = s; k = 0; while (*s && (isalpha (*s) || isdigit(*s) || *s == '\\' || *s == '_')) {if (*s == '\\') {++s; d[k++] = *s++;} else if (*s == '_') {d[k++] = ' '; ++s;} else d[k++] = *s++;} endToken = s; d[k] = 0;}
#define SHIFTNUM(d, s) {int k; SKIPBLANKS(s); begToken = s; k = 0; while (*s && (isalpha(*s) || isdigit(*s) || *s == '+' || *s == '-' || *s == '.')) {d[k++] = *s++;} endToken = s; d[k] = 0;}

extern char *begToken, *endToken;	/*Beginning and ending of current token*/

extern WinInfoPtr scriptWindow;

extern int nextLogElement;
#define logging 1			/*Always logging in case recording*/

#define ERROBJ	((ObjPtr) -1)		/*Evil test value*/

extern char *classNames[N_CLASS_IDS];
extern ObjPtr classClasses[N_CLASS_IDS];

/*Type casts*/
#define TC_NULL		0		/*Null type cast*/
#define TC_INTEGER	1		/*To integer*/

#ifdef PROTO
void BeginScript(char *);
void EndScript(void);
Bool ReadScriptLine(void);
Bool InterpretScriptLine(char *);
ObjPtr FindFullNamedObject(char *);
void MakeFullObjectName(char *, ObjPtr, ObjPtr);
Bool MakeObjectName(char *, ObjPtr);
void Log(char *);
void LogNoWindow(char *);
void LogControl(ObjPtr);
void LogVariable(ObjPtr, NameTyp);
void LogObjectName(ObjPtr);
char *PrintScriptObject(char *, ObjPtr);
void InhibitLogging(Bool);
char *PrintScriptString(char *, char *);
void ShowScriptControlPanels(Bool);
FILE *OpenLogFile(char *);
void CloseLogFile(void);
void CloseAllLogFiles(void);
char *ParseObjectArg(char *s, ObjPtr *o);
#else
void BeginScript();
void EndScript();
Bool ReadScriptLine();
Bool InterpretScriptLine();
ObjPtr FindFullNamedObject();
void MakeFullObjectName();
Bool MakeObjectName();
void Log();
void LogNoWindow();
void LogControl();
void LogVariable();
void LogObjectName();
void InhibitLogging();
char *PrintScriptString();
void ShowScriptControlPanels();
FILE *OpenLogFile();
void CloseLogFile();
void CloseAllLogFiles();
char *ParseObjectArg();
#endif
